package com.cftech.brand.supplier.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商信息
 *
 * @author faye
 * @date 2020/01/14
 */
@Data
public class BrandSupplier implements Serializable {

    /** 主键id */
    private Long id;
    /** 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;

    /** 名称 */
    @ExportConfig(value = "名称", width = 100)
    private String name;

    /** 邮箱 */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;

    /** 负责人姓名 */
    @ExportConfig(value = "负责人姓名", width = 100)
    private String personName;


    /** 负责人联系方式 */
    @ExportConfig(value = "负责人联系方式", width = 100)
    private String personMobile;

    @ExportConfig(value = "类别")
    private String classes;

    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    /** 备注 */
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;

    public BrandSupplier() {
        this.delFlag = false;
        this.status = "0";
    }

}