package com.cftech.base.org.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * t_orgtype 实体类
 * 组织分类表
 * Created by Neil 12/02/2017.
 */ 
@Data
public class Orgtype implements Serializable {
	/**
	 * 组织分类id
	 */
    @ExportConfig(value = "组织分类Id", width = 100, showLevel = 1)
    private Long id;

	/**
	 * 组织分类名称
	 */
	@ExportConfig(value = "组织分类名称", width = 100)
	private String name;

	/**
	 * 组织分类编码
	 */
	@ExportConfig(value = "组织分类编码", width = 100)
	private String number;

	/**
	 * 所属的账号
	 */
	private Long accountsId;

	/**
	 * 状态
	 */
	private String status;

	/**
	 * 创建时间
	 */
	private Timestamp createTime;

	/**
	 * updateTime
	 */
	private Timestamp updateTime;

	/**
	 * description
	 */
	private String description;

	/**
	 * delFlag
	 */
	private boolean delFlag;

	/**
	 * createBy
	 */
	private Long createBy;

	/**
	 * updateBy
	 */
	private Long updateBy;

	public Orgtype() {
		this.status = "0";
		this.delFlag = false;

	}

}