package com.cftech.questionnaire.core.paper_read.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.questionnaire.core.paper_read.model.Paper_read;
import com.cftech.questionnaire.core.paper_read.model.Paper_readDto;
import com.cftech.questionnaire.core.paper_read.service.Paper_readService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String PAPER_READ_VIEW = "qy:paper_read:view"
 * 查看:public static final String PAPER_READ_EDIT = "qy:paper_read:edit"
 *
 * @author byj
 * @date: 2018-10-10 17:43
 */
@Slf4j
@Controller
@RequestMapping("/a/paper_read")
public class Paper_readController {

    public static final String PAPER_READ_VIEW = "qy:paper_read:view";
    public static final String PAPER_READ_EDIT = "qy:paper_read:edit";

    @Autowired
    private Paper_readService paper_readService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = PAPER_READ_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long paper_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("paper_id",paper_id);
        return "paper_read/paper_readlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = PAPER_READ_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Paper_read paper_read = paper_readService.fetchById(id);
            model.addAttribute("data", paper_read);
        }
        return "paper_read/paper_readform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = PAPER_READ_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Paper_read paper_read, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (paper_read != null && paper_read.getId() != null) {
                paper_read.setUpdateBy(UserUtils.getUser().getId());
                paper_readService.update(paper_read);
                rtnJson.put("errorNo", 0);
            } else {
                paper_read.setNumber(codingruleUtils.getNumber(accountsId, Paper_read.class.getName()));
                paper_read.setAccountsId(accountsId);
                paper_read.setDelFlag(false);
                paper_read.setAccountsId(UserUtils.getmpaccounts(request));
                paper_read.setCreateBy(UserUtils.getUser().getId());
                paper_read.setUpdateBy(UserUtils.getUser().getId());
                paper_readService.save(paper_read);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PAPER_READ_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Paper_read paper_read, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("r.del_flag", Constants.DEL_FLAG_0);
        conds.equal("r.accounts_id", accountsId);
        if(!StringUtils.isEmpty(paper_read.getPaper_id())){
            conds.equal("r.paper_id",paper_read.getPaper_id());
        }
        Sort sort = new Sort("r.create_time", OrderType.DESC);

        List<Paper_read> list = paper_readService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = paper_readService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //导出
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value =  PAPER_READ_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Paper_read paper_read) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("r.del_flag", Constants.DEL_FLAG_0);
        conds.equal("r.accounts_id", accountsId);
        if(!StringUtils.isEmpty(paper_read.getPaper_id())){
            conds.equal("r.paper_id",paper_read.getPaper_id());
        }
        Sort sort = new Sort("r.create_time", OrderType.DESC);

        List<Paper_read> list = paper_readService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Paper_readDto.class, response).toExcel(list, "问卷浏览");
    }

    //删除数据
    @RequiresPermissions(value = PAPER_READ_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            paper_readService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
