package com.cftech.cos.core;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cos.config.cosconfig.model.Cosconfig;

import java.io.InputStream;

/**
 * Created by liuling on 2017/5/2.
 */
public interface CosService {

    /**
     * 上传文件到云存储
     *
     * @param cosconfig 云存储的设置
     * @param data 字节数据
     * @param path 文件路径
     * @return 成功与否及图片路径
     */
    JSONObject uploadFile(Cosconfig cosconfig, byte[] data, String path);

    /**
     * 上传文件到云存储
     *
     * @param cosconfig 云存储的设置
     * @param inputStream 字节流
     *
     * @param path 文件路径
     * @return 成功与否及图片路径
     */
    JSONObject uploadFile(Cosconfig cosconfig, InputStream inputStream, String path);

    /**
     * 上传文件到云存储
     *
     *
     * @param cosconfig 云存储的设置
     * @param file 文件
     * @param path 文件路径
     * @return 成功与否及图片路径
     */
//    JSONObject uploadFile(Cosconfig cosconfig, File file, String path);

    /**
     * 删除云存储中的文件
     *
     * @param cosconfig 云存储的设置
     * @param key 删除的文件，包含路径
     * @return 成功与否
     */
    JSONObject deleteFile(Cosconfig cosconfig, String key);
}
