package com.cftech.cms.exhibi_inquiries.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi_inquiries.model.Exhibi_inquiries;
import com.cftech.cms.exhibi_inquiries.model.Exhibi_inquiriesDto;
import com.cftech.cms.exhibi_inquiries.service.Exhibi_inquiriesService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EXHIBI_INQUIRIES_VIEW = "qy:exhibi_inquiries:view"
 * 查看:public static final String EXHIBI_INQUIRIES_EDIT = "qy:exhibi_inquiries:edit"
 *
 * @author byj
 * @date: 2018-09-11 16:10
 */
@Slf4j
@Controller
@RequestMapping("/a/exhibi_inquiries")
public class Exhibi_inquiriesController {

    public static final String EXHIBI_INQUIRIES_VIEW = "qy:exhibi_inquiries:view";
    public static final String EXHIBI_INQUIRIES_EDIT = "qy:exhibi_inquiries:edit";

    @Autowired
    private Exhibi_inquiriesService exhibi_inquiriesService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = EXHIBI_INQUIRIES_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,String exhibi_id) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        if(!StringUtils.isEmpty(exhibi_id)){
            model.addAttribute("exhibi_id",exhibi_id);
        }
        return "exhibi_inquiries/exhibi_inquirieslist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EXHIBI_INQUIRIES_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Exhibi_inquiries exhibi_inquiries = exhibi_inquiriesService.fetchById(id);
            model.addAttribute("data", exhibi_inquiries);
        }
        return "exhibi_inquiries/exhibi_inquiriesform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EXHIBI_INQUIRIES_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Exhibi_inquiries exhibi_inquiries, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (exhibi_inquiries != null && exhibi_inquiries.getId() != null) {
                exhibi_inquiries.setUpdateBy(UserUtils.getUser().getId());
                exhibi_inquiriesService.update(exhibi_inquiries);
                rtnJson.put("errorNo", 0);
            } else {
                exhibi_inquiries.setNumber(codingruleUtils.getNumber(accountsId, Exhibi_inquiries.class.getName()));
                exhibi_inquiries.setAccountsId(accountsId);
                exhibi_inquiries.setDelFlag(false);
                exhibi_inquiries.setAccountsId(UserUtils.getmpaccounts(request));
                exhibi_inquiries.setCreateBy(UserUtils.getUser().getId());
                exhibi_inquiries.setUpdateBy(UserUtils.getUser().getId());
                exhibi_inquiriesService.save(exhibi_inquiries);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EXHIBI_INQUIRIES_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Exhibi_inquiries exhibi_inquiries, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("e.accounts_id", accountsId);
        if (!StringUtils.isEmpty(exhibi_inquiries.getName())) {
            conds.like("e.name", exhibi_inquiries.getName());
        }
        if (!StringUtils.isEmpty(exhibi_inquiries.getContact())) {
            conds.like("e.contact", exhibi_inquiries.getContact());
        }
        if(!StringUtils.isEmpty(exhibi_inquiries.getCompany())){
            conds.like("e.company",exhibi_inquiries.getContact());
        }
        if(!StringUtils.isEmpty(exhibi_inquiries.getExhibi_id())){
            conds.equal("e.exhibi_id",exhibi_inquiries.getExhibi_id());
        }
        Sort sort = new Sort("e.create_time", OrderType.DESC);

        List<Exhibi_inquiries> list = exhibi_inquiriesService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = exhibi_inquiriesService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = EXHIBI_INQUIRIES_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            exhibi_inquiriesService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value =  EXHIBI_INQUIRIES_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response,Exhibi_inquiries exhibi_inquiries) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("e.accounts_id", accountsId);
        if (!StringUtils.isEmpty(exhibi_inquiries.getName())) {
            conds.like("e.name", exhibi_inquiries.getName());
        }
        if (!StringUtils.isEmpty(exhibi_inquiries.getContact())) {
            conds.like("e.contact", exhibi_inquiries.getContact());
        }
        if(!StringUtils.isEmpty(exhibi_inquiries.getCompany())){
            conds.like("e.company",exhibi_inquiries.getContact());
        }
        if(!StringUtils.isEmpty(exhibi_inquiries.getExhibi_id())){
            conds.equal("e.exhibi_id",exhibi_inquiries.getExhibi_id());
        }
        Sort sort = new Sort("e.create_time", OrderType.DESC);

        List<Exhibi_inquiries> list = exhibi_inquiriesService.fetchSearchByPage(conds, sort, 0, 0);

        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(Exhibi_inquiriesDto.class, response).toExcel(list, "相关问询信息");
    }

}
