package com.cftech.productintowareroom.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.productintowareroom.model.ProductIntoWareroom;
import com.cftech.productintowareroom.service.ProductIntoWareroomService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 产品入库单Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String PRODUCTINTOWAREROOM_VIEW = "qy:productIntoWareroom:view"
 * 查看:public static final String PRODUCTINTOWAREROOM_EDIT = "qy:productIntoWareroom:edit"
 *
 * @author Buyj
 * @date: 2020-09-27 17:38
 */
@Slf4j
@Controller
@RequestMapping("/a/productIntoWareroom")
public class ProductIntoWareroomController {

    public static final String PRODUCTINTOWAREROOM_VIEW = "qy:productIntoWareroom:view";
    public static final String PRODUCTINTOWAREROOM_EDIT = "qy:productIntoWareroom:edit";

    @Autowired
    private ProductIntoWareroomService productIntoWareroomService;


    //列表页面
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "productIntoWareroom/productIntoWareroomlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            ProductIntoWareroom productIntoWareroom = productIntoWareroomService.fetchById(id);
            model.addAttribute("data", productIntoWareroom);
        }
        return "productIntoWareroom/productIntoWareroomform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(ProductIntoWareroom productIntoWareroom, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (productIntoWareroom != null && productIntoWareroom.getId() != null) {
                productIntoWareroom.setUpdateBy(UserUtils.getUser().getId());
                productIntoWareroomService.update(productIntoWareroom);
                rtnJson.put("errorNo", 0);
            } else {
                productIntoWareroom.setAccountsId(accountsId);
                productIntoWareroom.setDelFlag(false);
                productIntoWareroom.setAccountsId(UserUtils.getmpaccounts(request));
                productIntoWareroom.setCreateBy(UserUtils.getUser().getId());
                productIntoWareroom.setUpdateBy(UserUtils.getUser().getId());
                productIntoWareroomService.save(productIntoWareroom);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, ProductIntoWareroom productIntoWareroom, HttpServletRequest request,String startTime) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if(!StringUtils.isEmpty(productIntoWareroom.getIntoWareroomNumber())){
            conds.like("into_wareroom_number",productIntoWareroom.getIntoWareroomNumber());
        }
        if(!StringUtils.isEmpty(startTime)){
            conds.equal("DATE_FORMAT(create_time,'%Y-%m-%d')",startTime);
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<ProductIntoWareroom> list = productIntoWareroomService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = productIntoWareroomService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            productIntoWareroomService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<ProductIntoWareroom> list = productIntoWareroomService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(ProductIntoWareroom.class, response).toExcel(list, "产品入库单信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(ProductIntoWareroom.class, response).toExcel(null, "产品入库单信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = PRODUCTINTOWAREROOM_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    ProductIntoWareroom productIntoWareroom = new ProductIntoWareroom();
                    productIntoWareroom.setAccountsId(accountId);
                    productIntoWareroomService.save(productIntoWareroom);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
