package com.cftech.order.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;

/**
 * @author ：licc
 * @date ：Created in 2020/10/16 17:37
 * @description：J
 */
public class JSONSeriableUtils extends JsonSerializer<Double> {
    @Override
    public void serialize(Double aDouble, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if(aDouble !=null) {
            DecimalFormat df = new DecimalFormat("0.00");
            df.setRoundingMode(RoundingMode.HALF_UP);
            jsonGenerator.writeString(df.format(aDouble));
        }else {//这个分支不要忘记了，否则将不输出这个属性的值
            jsonGenerator.writeString(aDouble.toString());
        }
    }
}
