package com.cftech.activity.oil.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.oil.model.Config;
import com.cftech.activity.oil.service.ConfigService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 机油活动配置Controller
 *
 * 权限字符串说明:
 * 查看:public static final String CONFIG_VIEW = "qy:config:view"
 * 查看:public static final String CONFIG_EDIT = "qy:config:edit"
 *
 * @author faye
 * @date: 2017-08-23 13:50
 */
@Slf4j
@Controller
@RequestMapping("/a/config")
public class ConfigController {

    public static final String CONFIG_VIEW = "qy:config:view";
    public static final String CONFIG_EDIT = "qy:config:edit";

    @Autowired
    private ConfigService configService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = CONFIG_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "config/configlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = CONFIG_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Config config = configService.fetchById(id);
            model.addAttribute("data", config);
        }
        return "config/configform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = CONFIG_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Config config, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (config != null && config.getId() != null) {
                config.setUpdateBy(UserUtils.getUser().getId());
                configService.update(config);
                rtnJson.put("errorNo", 0);
            } else {
                //config.setNumber(codingruleUtils.getNumber(accountsId, Config.class.getName()));
                config.setAccountsId(accountsId);
                config.setDelFlag(false);
                config.setAccountsId(UserUtils.getmpaccounts(request));
                config.setCreateBy(UserUtils.getUser().getId());
                config.setUpdateBy(UserUtils.getUser().getId());
                configService.save(config);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = CONFIG_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Config config, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(config.getNumber())) {
            conds.like("number", config.getNumber());
        }
        if (!StringUtils.isEmpty(config.getName())) {
            conds.like("name", config.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Config> list = configService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = configService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = CONFIG_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            configService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = CONFIG_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Config> list = configService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Config.class, response).toExcel(list, "机油活动配置信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = CONFIG_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(Config.class, response).toExcel(null, "机油活动配置信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = CONFIG_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Config config = new Config();
                    config.setAccountsId(accountId);
                    String number=rowData.get(0);
                    config.setNumber(number);
                    config.setName(rowData.get(1));
                    config.setType(rowData.get(2));
                    config.setCount(rowData.get(3));
                    config.setUnit(rowData.get(4));
                    Conds conds=new Conds();
                    conds.equal("del_flag",0);
                    conds.equal("number",number);
                    Config old=configService.fetchSearchByConds(conds);
                    if(old!=null){
                        config.setId(old.getId());
                        configService.update(config);
                    }else{
                        configService.save(config);
                    }
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }
        return list(request, model);
    }

}
