package com.cftech.activity.log.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.EggsLog;
import com.cftech.activity.log.model.EggsLogDto;
import com.cftech.activity.log.service.EggsLogService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 砸金蛋活动记录表Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String EGGSLOG_VIEW = "qy:EggsLog:view"
 * 查看:public static final String EGGSLOG_EDIT = "qy:EggsLog:edit"
 *
 * @author wuxf
 * @date: 2017-04-28
 */
@Slf4j
@Controller
@RequestMapping("/a/activity/eggsLog")
public class EggsLogController {

    public static final String EGGSLOG_VIEW = "activity:eggsLog:view";
    public static final String EGGSLOG_EDIT = "activity:eggsLog:edit";

    @Autowired
    private EggsLogService eggsLogService;


    //列表页面
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "eggsLog/eggsLoglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            EggsLog eggsLog = eggsLogService.fetchById(id);
            model.addAttribute("data", eggsLog);
        }
        return "EggsLog/EggsLogform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = EGGSLOG_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(EggsLog eggsLog, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (eggsLog != null && eggsLog.getId() != null) {
                eggsLog.setUpdateBy(UserUtils.getUser().getId());
                eggsLogService.update(eggsLog);
                rtnJson.put("errorNo", 0);
            } else {
                eggsLog.setAccountsId(accountsId);
                eggsLog.setDelFlag(false);
                eggsLog.setAccountsId(UserUtils.getmpaccounts(request));
                eggsLog.setCreateBy(UserUtils.getUser().getId());
                eggsLog.setUpdateBy(UserUtils.getUser().getId());
                eggsLogService.save(eggsLog);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = EGGSLOG_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, EggsLogDto eggsLogDto, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("el.accounts_id", accountsId);
        if (!StringUtils.isEmpty(eggsLogDto.getTitle())) {
            conds.like("el.title", eggsLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(eggsLogDto.getName())) {
            conds.like("m.name",eggsLogDto.getName());
        }


        Sort sort = new Sort("el.create_time", OrderType.DESC);

        List<EggsLogDto> list = eggsLogService.fetchSearchByPageDto(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = eggsLogService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = EGGSLOG_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            eggsLogService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequiresPermissions(value = EGGSLOG_EDIT)
    @RequestMapping(value = "/exportExcel",method = RequestMethod.GET)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, EggsLogDto eggsLogDto){
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("e.del_flag", Constants.DEL_FLAG_0);
        conds.equal("el.accounts_id", accountsId);
        if (!StringUtils.isEmpty(eggsLogDto.getTitle())) {
            conds.like("el.title", eggsLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(eggsLogDto.getName())) {
            conds.like("m.name",eggsLogDto.getName());
        }


        Sort sort = new Sort("el.create_time", OrderType.DESC);

        List<EggsLogDto> list = eggsLogService.fetchSearchByPageDto(conds, sort, 0, 0);
//        if(list!=null && list.size()>0){
//            for (WheelLogDto wheelLogDto1 : list){
//                if(wheelLogDto1.getCreate_time()!=null)
//                    wheelLogDto1.setCreate_time_str(DateFormatUtils.getDateFormat(wheelLogDto1.getCreate_time(),"yyyy-MM-dd HH:mm" ));
//            }
//        }
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(EggsLogDto.class, response).toExcel(list, "砸金蛋参与人员信息");
    }

}
