package com.cftech.brand.market.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.brand.market.model.BrandMarketLeader;
import com.cftech.brand.market.service.BrandMarketLeaderService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 市场部领导配置Controller
 *
 * 权限字符串说明:
 * 查看:public static final String BRANDMARKETLEADER_VIEW = "qy:brandMarketLeader:view"
 * 查看:public static final String BRANDMARKETLEADER_EDIT = "qy:brandMarketLeader:edit"
 *
 * @author faye
 * @date 2020/02/11
 */
@Slf4j
@Controller
@RequestMapping("/a/brandMarketLeader")
public class BrandMarketLeaderController {

    public static final String BRANDMARKETLEADER_VIEW = "qy:brandMarketLeader:view";
    public static final String BRANDMARKETLEADER_EDIT = "qy:brandMarketLeader:edit";

    @Autowired
    private BrandMarketLeaderService brandMarketLeaderService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    /**
     * 列表页面
     *
     * @param request
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDMARKETLEADER_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "brandMarketLeader/brandMarketLeaderlist";
    }

    /**
     * 编辑页面（新增、修改）
     *
     * @param request
     * @param id
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDMARKETLEADER_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        BrandMarketLeader marketing = brandMarketLeaderService.fetchSearchByConds(conds);
        model.addAttribute("data", marketing);
        return "brandMarketLeader/brandMarketLeaderform";
    }

    /**
     * 提交数据（新增、修改）
     *
     * @param brandMarketLeader
     * @param model
     * @param request
     * @return
     */
    @RequiresPermissions(value = BRANDMARKETLEADER_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(BrandMarketLeader brandMarketLeader, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            brandMarketLeader.setUpdateBy(UserUtils.getUser().getId());
            if (brandMarketLeader != null && brandMarketLeader.getId() != null) {
                brandMarketLeaderService.update(brandMarketLeader);
                rtnJson.put("errorNo", 0);
            } else {
                brandMarketLeader.setNumber(codingruleUtils.getNumber(accountsId, BrandMarketLeader.class.getName()));
                brandMarketLeader.setAccountsId(accountsId);
                brandMarketLeader.setDelFlag(false);
                brandMarketLeader.setAccountsId(UserUtils.getmpaccounts(request));
                brandMarketLeader.setCreateBy(UserUtils.getUser().getId());
                brandMarketLeaderService.save(brandMarketLeader);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error("保存市场部领导配置异常:"+e.getMessage());
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    /**
     * 获取列表数据
     *
     * @param iDisplayStart
     * @param iDisplayLength
     * @param brandMarketLeader
     * @param request
     * @return
     */

    @RequiresPermissions(value = BRANDMARKETLEADER_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, BrandMarketLeader brandMarketLeader, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(brandMarketLeader.getNumber())) {
            conds.like("number", brandMarketLeader.getNumber());
        }
        if (!StringUtils.isEmpty(brandMarketLeader.getName())) {
            conds.like("name", brandMarketLeader.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<BrandMarketLeader> list = brandMarketLeaderService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = brandMarketLeaderService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    /**
     * 删除数据
     *
     * @param id
     * @return
     */
    @RequiresPermissions(value = BRANDMARKETLEADER_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            brandMarketLeaderService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    /**
     * 导出
     *
     * @param request
     * @param response
     */
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = BRANDMARKETLEADER_VIEW)
    public void exportExcel(HttpServletRequest request,BrandMarketLeader brandMarketLeader, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(brandMarketLeader.getNumber())) {
            conds.like("number", brandMarketLeader.getNumber());
        }
        List<BrandMarketLeader> list = brandMarketLeaderService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(BrandMarketLeader.class, response).toExcel(list, "市场部领导配置信息");
    }

    /**
     * 模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = BRANDMARKETLEADER_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(BrandMarketLeader.class, response).toExcel(null, "市场部领导配置信息");
    }

    /**
     * 导入
     *
     * @param request
     * @param file
     * @param model
     * @return
     */
    @RequestMapping("/importExcel")
    @RequiresPermissions(value = BRANDMARKETLEADER_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    BrandMarketLeader brandMarketLeader = new BrandMarketLeader();
                    brandMarketLeader.setAccountsId(accountId);

                    brandMarketLeader.setNumber(rowData.get(0));


                    brandMarketLeader.setName(rowData.get(1));


                    brandMarketLeader.setEmail(rowData.get(2));

                    brandMarketLeaderService.save(brandMarketLeader);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
