package com.cftech.base.org.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * t_qyuser 实体类
 * 企业号人员表
 * Created by Neil 14/02/2017.
 */
@Data
public class Qyuser implements Serializable {

    /**
     * 人员id
     */
    private Long id;

    /**
     * 职位Id
     */
    private Long positionId;

    /**
     * role:'0', 未分配， '1': 店长, '2': 导购
     */
    private String role;

    private Long storeId;

    private String loginName;

    private String storeName;

    /**
     * 所属组织Id
     */
    //@ExportConfig(value = "所属组织", width = 100)
    private Long orgId;

    /**
     * 人员名称
     */
    @ExportConfig(value = "姓名", width = 100)
    private String name;

    /**
     * 人员头像
     */
    private String avatar;

    /**
     * 手机号码
     */
    @ExportConfig(value = "手机号", width = 100)
    private String mobile;

    /**
     * 微信号
     */
    private String wxno;

    /**
     * 电子邮箱
     */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;

    /**
     * 性别
     */
    private String gender;

    /**
     * 所属的账号
     */
    private Long accountsId;

    /**
     * 微信的人员Id (企业号唯一主键)
     */
    private String wxuserId;


    /**
     * 标签Ids
     */
    private String tagIds;

    /**
     * 微信状态
     */
    private String status;

    /**
     * 创建时间
     */
    private Timestamp createTime;

    /**
     * updateTime
     */
    private Timestamp updateTime;

    /**
     * description
     */
    private String description;

    /**
     * delFlag
     */
    private boolean delFlag;

    /**
     * createBy
     */
    private Long createBy;

    /**
     * updateBy
     */
    private Long updateBy;

    /**
     * 绑定的二维码
     */
    private String qrcode;

    /**
     * 用户类型 0:客服 ;1:药师; 2:医生; 3:订单员 4:其他
     */
    private String userType;

    /**
     * 峰值
     */
    private Long peakVal;

    /**
     * 药师医生已分配咨询单数量(峰值未满)
     */
    private Long assigned;

    /**
     * 药师医生已分配咨询单数量(峰值未满)
     */
    private Long unAssigned;


    private String img;


    public Qyuser() {
        this.delFlag = false;
//        this.peakVal = 0L;
//        this.assigned = 0L;
//        this.unAssigned = 0L;
    }
}