/**
 * Created by liuling on 16/3/4.
 */
/**
 * week picker的头部显示
 */
var weekpicker = (function() {
    'use strict';
    var $ = window.Dom7;
    var t7 = window.Template7;

    var weekPicker = function (params) {
        var p = this;
        var MILLIS_IN_DAY = 86400000;
        var MILLIS_IN_WEEK = MILLIS_IN_DAY * 7;
        var today = new Date().setHours(0,0,0,0);
        var currentStartTime = new Date().setHours(0,0,0,0);
        var swiper;

        var selectedValue;

        //参数定义
        p.params = {
            mode:"dev",
            app: '100',
            tokenId: 'wxfdb9fde3bc87db72',
            index:parseInt(Math.random()*100000),
            tarId:"weekhead",
            callback:null
        };

        // Extend defaults with parameters
        for (var param in params) {
            p.params[param] = params[param];

        }

        var weekHead =
            '<div class="content-block-inner week-block-inner">'+
            '<div class="picker-modal picker-calendar picker-modal-inline">'+
            '<div class="toolbar calendar-custom-toolbar">'+
            '<div class="toolbar-inner">'+
            '<div class="left"></div>'+
            '<div class="center" id="weekhead-{{index}}">{{weekTitle}}</div>'+
            '<div class="right"></div>'+
            '</div>'+
            '</div>'+
            '<div class="picker-modal-inner">'+
            '<div class="picker-calendar-week-days">'+
            '<div class="picker-calendar-week-day "> 周一</div>'+
            '<div class="picker-calendar-week-day "> 周二</div>'+
            '<div class="picker-calendar-week-day "> 周三</div>'+
            '<div class="picker-calendar-week-day "> 周四</div>'+
            '<div class="picker-calendar-week-day "> 周五</div>'+
            '<div class="picker-calendar-week-day picker-calendar-week-day-weekend"> 周六</div>'+
            '<div class="picker-calendar-week-day picker-calendar-week-day-weekend"> 周日</div>'+
            '</div>'+
            '<div class="picker-calendar-months">'+
            '<div class="picker-calendar-months-wrapper swiper-container picker-calendar-weeks-container swiper-container-horizontal">'+
            '<div class="swiper-wrapper" id="weekcontent-{{index}}">'+
            '</div>'+
            '</div>'+
            '</div>'+
            '</div>'+
            '</div>'+
            '</div>';

        p.initLayout = function() {

            var tmpObj = {
                index: p.params.index,
                weekTitle:weekTitle(today)
            };
            renderTemplate(weekHead, tmpObj, p.params.tarId);

            var prevWeekHTML = weekHTML(today, 'prev');
            var currentWeekHTML = weekHTML(today, 'current');
            var nextWeekHTML = weekHTML(today,'next');
            var weeksHTML = prevWeekHTML + currentWeekHTML + nextWeekHTML;

            renderTemplate(weeksHTML, {}, 'weekcontent-'+ p.params.index);
            //第一次的加载
            $('.picker-calendar-day-today').addClass('picker-calendar-day-selected');
            initSwiper();
            bindEvent();
            selectedValue = weekTitle(today);

        };

        p.getSelectedDate = function() {
        	return selectedValue;
        };

        function bindEvent() {
            $('#weekcontent-'+ p.params.index).on('click', '.picker-calendar-day', handleCallBack);
        }

        var handleCallBack = function() {
            $('#weekcontent-'+ p.params.index).find('.picker-calendar-day-selected').removeClass('picker-calendar-day-selected');
            selectedValue = changeWeekTitle($(this));
            $('#weekhead-'+ p.params.index).text(selectedValue);
            $(this).addClass('picker-calendar-day-selected');
            if (p.params.callback) {
                p.params.callback(selectedValue);
            }
        };

        function changeWeekTitle(obj) {
            var year = obj.attr('data-year');
            var month = parseInt(obj.attr('data-month')) >= 10 ? obj.attr('data-month') : '0'+obj.attr('data-month');
            var day = parseInt(obj.attr('data-day')) >= 10 ? obj.attr('data-day'):'0'+obj.attr('data-day');
            return year+'-'+month+'-'+day;
        }

        function initSwiper() {
            swiper = new Swiper('.picker-calendar-weeks-container', {
                initialSlide:1
            });
            swiper.on('onSlideNextEnd', function () {
                currentStartTime = currentStartTime + MILLIS_IN_WEEK;
                var nextWeekHTML = weekHTML(currentStartTime,'next');
                swiper.appendSlide(nextWeekHTML);
                swiper.removeSlide(0);
            });
            swiper.on('onSlidePrevEnd', function () {
                currentStartTime = currentStartTime - MILLIS_IN_WEEK;
                var prevWeekHTML = weekHTML(currentStartTime,'prev');
                swiper.prependSlide(prevWeekHTML);
                swiper.removeSlide(3);
            });
        }

        var weekTitle = function(date) {
            date = new Date(date);
            var year = date.getFullYear(),
                month = date.getMonth()+ 1,
                day = date.getDate();

            month = parseInt(month) >= 10 ? month : '0'+month;
            day = parseInt(day) >= 10 ? day:'0'+day;
            return year+'-'+month+'-'+day;
        };

        var weekHTML = function(date, offset) {
            date = new Date(date);
            var year = date.getFullYear(),
                month = date.getMonth(),
                day = date.getDate();

            var weekFirst = date.getDate() - date.getDay() + 1;

            var startDateTime = new Date(year, month, weekFirst).getTime();

            if (offset === 'next') {
                startDateTime = startDateTime + MILLIS_IN_WEEK;

            }
            if (offset === 'prev') {
                startDateTime = startDateTime - MILLIS_IN_WEEK;

            }


            var dayDate, currentValues = [], j,
                cols = 7,
                weekHTML = '',
                rowHTML = '';

            currentValues.push(startDateTime);
            for (var i = 1; i <= cols; i++) {
                currentValues.push(new Date(startDateTime + MILLIS_IN_DAY*i).getTime());
            }

            //currentValues存储了7天的具体日期

            for (j = 1; j <= cols; j++) {
                var col = j;

                var addClass = '';
                dayDate = currentValues[j-1];
                // Today
                if (dayDate === today) addClass += ' picker-calendar-day-today';

                dayDate = new Date(dayDate);

                var dayYear = dayDate.getFullYear();
                var dayMonth = dayDate.getMonth()+1;
                var dayNumber = dayDate.getDate();

                rowHTML += '<div data-year="' + dayYear + '" data-month="' + dayMonth + '" data-day="' + dayNumber + '" class="picker-calendar-day' + (addClass) + '" data-date="' + (dayYear + '-' + dayMonth + '-' + dayNumber) + '"><span>' + dayNumber + '</span></div>';
            }
            weekHTML += '<div class="picker-calendar-row">' + rowHTML + '</div>';

            weekHTML = '<div class="swiper-slide" data-year="' + year + '" data-month="' + month + '">' + weekHTML + '</div>';
            return weekHTML;
        };

    };

    return weekPicker;
})();