package com.cftech.workshop.album.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.album.dao.AlbumMapper;
import com.cftech.workshop.album.model.Album;
import com.cftech.workshop.album_pic.dao.Album_picMapper;
import com.cftech.workshop.album_pic.model.Album_pic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 相册图集
 * Created by Ago on 2018/7/18.
 */
@RestController
@RequestMapping(value = "/mobile/auth/album")
public class MobileAlbumController {

    @Autowired
    private AlbumMapper albumMapper;

    @Autowired
    private Album_picMapper album_picMapper;

    /**
     * 相册图集
     * @param meetingId
     * @return
     */
    @RequestMapping(value = "/getalbum", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getalbum(Long meetingId){
        JSONObject jsonObject = new JSONObject();
       try {
           jsonObject.put("errorNo",0);
           if(meetingId!=0){
               Map para = new HashMap();
               Conds conds =new Conds();
               conds.equal("a.workshop_id",meetingId);
               conds.equal("a.del_flag",0);
               Sort sort = new Sort("create_time", OrderType.DESC);
               para.put("conds",conds);
               para.put("sort",sort);
               List<Album> album = albumMapper.slelectcountalbumpic(para);
               if(album!=null){
                  jsonObject.put("data",album);

               }

           }
       }catch (Exception e){
           e.printStackTrace();
           jsonObject.put("errorNo",1);
       }
        return  jsonObject;
    }

    /**
     *
     * @param id 相册图集的ID
     * @param createtime 创建相册图集的时间
     * @return
     */
    @RequestMapping(value = "/getalbumdetails", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getalbumdetails(Long id, String createtime){
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("errorNo",0);
            jsonObject.put("ceate_time",createtime);
            if(StringUtils.isNoneBlank(String.valueOf(id))){
                Map para = new HashMap();
                Conds conds = new Conds();
                conds.equal("album_id",id);
                conds.equal("del_flag",0);
                Sort sort = new Sort("create_time",OrderType.DESC);
                para.put("conds",conds);
                para.put("sort",sort);
                List<Album_pic> list = album_picMapper.fetchSearchByPage(para);
                if(list!=null){
                    jsonObject.put("data",list);
                }
                int count = album_picMapper.count(para);
                jsonObject.put("count",count); //张数
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

}
