package com.cftech.common.manager.service.impl;

import com.cftech.common.manager.model.Manager;
import com.cftech.common.manager.dao.ManagerMapper;
import com.cftech.common.manager.model.ManagerDto;
import com.cftech.common.manager.service.ManagerService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 通用申请单管理员配置ServiceImpl
*
* @author faye
* @date: 2019-08-14 17:21
*/
@Service("managerService")
public class ManagerServiceImpl extends GenericServiceImpl<Manager> implements ManagerService {

@Autowired
@Qualifier("managerMapper")
private ManagerMapper managerMapper;

@Override
public GenericDao<Manager> getGenericMapper() {
return managerMapper;
}

    @Override
    public boolean emptyTable(String[] ids,Long createBy,Long accountsId,Long typeform) {
        managerMapper.emptyTable(typeform);
        if(ids!=null && ids.length>0){
            for(String str : ids){
                Manager manager = new Manager();
                manager.setOpenid(str);
                manager.setCreateBy(createBy);
                manager.setUpdateBy(createBy);
                manager.setAccountsId(accountsId);
                manager.setTypeform(typeform);
                managerMapper.save(manager);
            }
        }
        return true;
    }

    @Override
    public List<ManagerDto> fetchOpenidNickName(Long typeform) {
        Map<String,Object> parmas = new HashMap<>();
        parmas.put("typeform",typeform);
        return managerMapper.fetchOpenidNickName(typeform);
    }
}