package com.cftech.brand.apply.detail.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.brand.apply.detail.model.BrandApplyDetail;
import com.cftech.brand.apply.detail.service.BrandApplyDetailService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 品牌申请详情Controller
 *
 * 权限字符串说明:
 * 查看:public static final String BRANDAPPLYDETAIL_VIEW = "qy:brandApplyDetail:view"
 * 查看:public static final String BRANDAPPLYDETAIL_EDIT = "qy:brandApplyDetail:edit"
 *
 * @author faye
 * @date 2020/01/15
 */
@Slf4j
@Controller
@RequestMapping("/a/brandApplyDetail")
public class BrandApplyDetailController {

    public static final String BRANDAPPLYDETAIL_VIEW = "qy:brandApplyDetail:view";
    public static final String BRANDAPPLYDETAIL_EDIT = "qy:brandApplyDetail:edit";

    @Autowired
    private BrandApplyDetailService brandApplyDetailService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    /**
     * 列表页面
     *
     * @param request
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDAPPLYDETAIL_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "brandApplyDetail/brandApplyDetaillist";
    }

    /**
     * 编辑页面（新增、修改）
     *
     * @param request
     * @param id
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDAPPLYDETAIL_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            BrandApplyDetail brandApplyDetail = brandApplyDetailService.fetchById(id);
            model.addAttribute("data", brandApplyDetail);
        }
        return "brandApplyDetail/brandApplyDetailform";
    }

    /**
     * 提交数据（新增、修改）
     *
     * @param brandApplyDetail
     * @param model
     * @param request
     * @return
     */
    @RequiresPermissions(value = BRANDAPPLYDETAIL_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(BrandApplyDetail brandApplyDetail, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            brandApplyDetail.setUpdateBy(UserUtils.getUser().getId());
            if (brandApplyDetail != null && brandApplyDetail.getId() != null) {
                brandApplyDetailService.update(brandApplyDetail);
                rtnJson.put("errorNo", 0);
            } else {
                brandApplyDetail.setNumber(codingruleUtils.getNumber(accountsId, BrandApplyDetail.class.getName()));
                brandApplyDetail.setAccountsId(accountsId);
                brandApplyDetail.setDelFlag(false);
                brandApplyDetail.setAccountsId(UserUtils.getmpaccounts(request));
                brandApplyDetail.setCreateBy(UserUtils.getUser().getId());
                brandApplyDetailService.save(brandApplyDetail);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error("保存品牌申请详情异常:"+e.getMessage());
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    /**
     * 获取列表数据
     *
     * @param iDisplayStart
     * @param iDisplayLength
     * @param brandApplyDetail
     * @param request
     * @return
     */

    @RequiresPermissions(value = BRANDAPPLYDETAIL_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, BrandApplyDetail brandApplyDetail, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(brandApplyDetail.getNumber())) {
            conds.like("number", brandApplyDetail.getNumber());
        }
        if (!StringUtils.isEmpty(brandApplyDetail.getMaterialId())) {
            conds.equal("material_id", brandApplyDetail.getMaterialId());
        }
        if (!StringUtils.isEmpty(brandApplyDetail.getQuantity())) {
            conds.equal("quantity", brandApplyDetail.getQuantity());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<BrandApplyDetail> list = brandApplyDetailService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = brandApplyDetailService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    /**
     * 删除数据
     *
     * @param id
     * @return
     */
    @RequiresPermissions(value = BRANDAPPLYDETAIL_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            brandApplyDetailService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    /**
     * 导出
     *
     * @param request
     * @param response
     */
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = BRANDAPPLYDETAIL_VIEW)
    public void exportExcel(HttpServletRequest request,BrandApplyDetail brandApplyDetail, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(brandApplyDetail.getNumber())) {
            conds.like("number", brandApplyDetail.getNumber());
        }
        if (!StringUtils.isEmpty(brandApplyDetail.getMaterialId())) {
            conds.equal("material_id", brandApplyDetail.getMaterialId());
        }
        if (!StringUtils.isEmpty(brandApplyDetail.getQuantity())) {
            conds.equal("quantity", brandApplyDetail.getQuantity());
        }
        List<BrandApplyDetail> list = brandApplyDetailService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(BrandApplyDetail.class, response).toExcel(list, "品牌申请详情信息");
    }

}
