package com.cftech.base.org.web;

import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.sql.Conds;
import com.cftech.sys.model.User;
import com.cftech.sys.service.UserService;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by user on 2017/12/11.
 */
@RestController
@RequestMapping(value = "/mobile/auth/guideLogin")
@Slf4j
public class MobileGuideLoginController {

    @Autowired
    private UserService userService;

    @Autowired
    private QyuserService qyuserService;




    //判断当前登录人的信息
    @RequestMapping(value = "/login", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String login(String userName,String password) {
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("errorNo", "0");
        rtnJson.put("errorMsg", "");

        //校验是否可以登录,并返回QYUSERID。
        Conds conds = new Conds();
        conds.equal("username",userName);
        conds.equal("password",password);
        conds.equal("delflag", 0);
        conds.equal("state", 1);
        User authentication = userService.fetchSearchByConds(conds);
        if (authentication == null) {
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "用户名或者密码不正确，请重试！");
        }else
        {
//            //根据ID， 查询对应的QY 用户身份
//            Map<String,Object> map = new HashMap<String,Object>();
//            map.put("id",authentication.getId());
//            List<Qyuser> users =  qyuserService.getLogInfo(map);
//            if(users==null||users.size()==0)
//            {
//                rtnJson.put("errorNo", "1");
//                rtnJson.put("errorMsg", "用户名或者密码不正确，请重试！");
//            }else
//            {
//                Qyuser currUser=users.get(0);
//                if(currUser.getIsVer().equals("0")){
//                    rtnJson.put("errorNo", "0");
//                    rtnJson.put("data", users.get(0));
//                }else{
//                    rtnJson.put("errorNo", "1");
//                    rtnJson.put("errorMsg", "无核销权限！");
//                }
//
//            }
        }
        return rtnJson.toString();
    }

    //修改密码
    @RequestMapping(value = "/updatePassword", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updatePassword(Long id, String password, String newpassword) {
        JSONObject rtnJson = new JSONObject();
        User oldUser = userService.fetchByQyuserId(id);
        if (oldUser == null) {
            rtnJson.put("errorCode", "1");
            return rtnJson;
        }

        if (!password.equals(oldUser.getPassword())) {
            rtnJson.put("errorCode", "1");
            return rtnJson;
        }

        User user = new User();
        user.setId(oldUser.getId());
        user.setPassword(newpassword);
        userService.update(user);
        rtnJson.put("errorCode", "0");
        return rtnJson;
    }
}
