package com.cftech.questionnaire.core.questionscategory.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.questionscategory.dao.QuestionscategoryMapper;
import com.cftech.questionnaire.core.questionscategory.model.Questionscategory;
import com.cftech.questionnaire.core.questionscategory.service.QuestionscategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 问卷分类ServiceImpl
 *
 * @author Neil
 * @date: 2017-05-23 13:24
 */
@Service("questionscategoryService")
public class QuestionscategoryServiceImpl extends GenericServiceImpl<Questionscategory> implements QuestionscategoryService {

    @Autowired
    @Qualifier("questionscategoryMapper")
    private QuestionscategoryMapper papercategoryMapper;

    @Override
    public GenericDao<Questionscategory> getGenericMapper() {
        return papercategoryMapper;
    }

    @Override
    public List<Questionscategory> fetchSearchByPage(Long parentId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("pId", parentId);
        if (parentId == 0) {
            params.put("pId", parentId);
        } else {
            params.put("pId", "," + parentId);
        }

        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchSearchByPage(params);
    }

    @Override
    public List<Questionscategory> fetchTreeByPage(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchTreeByPage(params);
    }

    @Override
    public int count(Long parentId, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("pId", parentId);
        params.put("conds", conds);
        return papercategoryMapper.count(params);
    }
}