package org.mp.api.wxstore.stock;

import net.sf.json.JSONObject;
import org.mp.api.core.common.WxstoreUtils;
import org.mp.api.core.util.HttpRequestProxy;
import org.mp.api.wxstore.stock.model.StockInfo;
import org.mp.api.wxstore.stock.model.StockRtnInfo;


/**
 * 微信小店 - 库存
 * @author zhangdaihao
 *
 */
public class JwStockAPI {
	// 增加库存
	private static String add_stock_url = "https://api.weixin.qq.com/merchant/stock/add?access_token=ACCESS_TOKEN";
	// 减少库存
	private static String sub_stock_url = "https://api.weixin.qq.com/merchant/stock/reduce?access_token=ACCESS_TOKEN";

	/**
	 * 增加库存
	 */
	public static StockRtnInfo doAddStock(String newAccessToken, StockInfo stockInfo) {
		if (newAccessToken != null) {
			String requestUrl = add_stock_url.replace("ACCESS_TOKEN", newAccessToken);
			JSONObject obj = JSONObject.fromObject(stockInfo);
			JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
			StockRtnInfo stockRtnInfo = (StockRtnInfo)JSONObject.toBean(result, StockRtnInfo.class);
			return stockRtnInfo;
		}
		return null;
	}

	/**
	 * 减少库存
	 */
	public static StockRtnInfo doSubStock(String newAccessToken, StockInfo stockInfo) {
		if (newAccessToken != null) {
			String requestUrl = sub_stock_url.replace("ACCESS_TOKEN", newAccessToken);
			JSONObject obj = JSONObject.fromObject(stockInfo);
			JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
			StockRtnInfo stockRtnInfo = (StockRtnInfo)JSONObject.toBean(result, StockRtnInfo.class);
			return stockRtnInfo;
		}
		return null;
	}

	public static void main(String[] args) {
		try{
			String url = "http://api.weixin.qq.com/cgi-bin/poi/getwxcategory?access_token=";
			url+="CIiTgMI3SRCzi9yAKccn_tr-xpgPr3tZGsBCRDPesqk-3fiSVtdohMEMAmRxIJK823PnAP6aQCPA0vjcY59NGuKC7FzFnMSE3UTGHvmyKJOjGFhm-GUlXKxR122efgSCTUEeAJAEFP";
			String rtn =HttpRequestProxy.doGet(url,"utf-8");
			System.out.println(rtn.toString());
		}catch (Exception e){
			e.printStackTrace();
		}



	}

}
