package com.cftech.mp.wechat.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.mp.wechat.dao.QrcodeMapper;
import com.cftech.mp.wechat.model.Qrcode;
import com.cftech.mp.wechat.model.QrcodeDto;
import com.cftech.mp.wechat.service.QrcodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * qrcodeService
 * Created by mb 01/11/2016.
 */
@Service("qrcodeService")
public class QrcodeServiceImpl extends GenericServiceImpl<Qrcode> implements QrcodeService {

	/**
	 * qrcodeMapper
	 */
	@Autowired
	@Qualifier("qrcodeMapper")
	private QrcodeMapper qrcodeMapper;

	@Override
	public GenericDao<Qrcode> getGenericMapper() {
		return qrcodeMapper;
	}

	@Override
	public List<QrcodeDto> fetchSearchByPageStore(Conds conds, Sort sort,
			int page, int pageSize) {
		Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
		return qrcodeMapper.fetchSearchByPageStore(params);
	}

	@Override
	public int countStore(Conds conds) {
		Map<String, Object> params = new HashMap<String, Object>();
	    params.put("conds", conds);
		return qrcodeMapper.countStore(params);
	}
}
