package com.cftech.membercard.register.web;

import com.cftech.core.sql.Conds;
import com.cftech.membercard.register.model.Register;
import com.cftech.membercard.register.service.RegisterService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by faye on 2017/7/5.
 * 会员注册配置
 */
@RestController
@RequestMapping(value="/mobile/auth/register/config")
public class MobileRegisterController {

    private static final Logger log= LoggerFactory.getLogger(MobileRegisterController.class);
    @Autowired
    private RegisterService registerService;

    @RequestMapping(value="/getConfig",method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String getConfig(@RequestParam Long accountId){
        JSONObject rtnJson=new JSONObject();
        rtnJson.put("errorNo","0");
        try {
            Conds conds=new Conds();
            conds.equal("accounts_id",accountId);
            conds.equal("del_flag","0");
            Register register=registerService.fetchSearchByConds(conds);
            if(register!=null){
                rtnJson.put("data",register.getContent());
            }else{
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","未获取到配置项!");
            }
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","服务器异常!");
            log.error("exception by  getConfig in MobileRegisterController.class");
        }
        return rtnJson.toString();
    }
}
