package com.cftech.core.mybatis.mybatis;

import com.cftech.core.mybatis.AbstractGenerator;
import com.cftech.core.util.StringUtils;


/**
 * Created by lisw on 2016-08-05
 */
public abstract class AbstractMybatisGenerator extends AbstractGenerator {

	/**
	 * 点
	 */
	protected final String pointStr = ".";

	/**
	 * semicolon
	 */
	protected final String semicolon = ";";

	/**
	 * enter
	 */
	protected final String enter = "\r\n";

	/**
	 * tab
	 */
	protected final String tab = "\t";

	/**
	 * author name
	 */
	protected String authorName;

	/**
	 * 功能：将输入字符串的首字母改成大写
	 * @param str
	 * @return 首字母改成大写的字符串
	 */
	protected String initcap(String str) {
		return StringUtils.capitalize(transLowerCamelCase(str));
	}

	/**
	 * 功能：下划线转为驼峰,且去掉相应的关键字
	 * @param str
	 * @return 驼峰字符串
	 */
	protected String transLowerCamelCase(String str) {
		String tempStr = str;
		if ("private".equals(str)) {
			tempStr += "ly";
		}
		if ("count(*)".equals(str)) {
			tempStr = "countAll";
		}

		return StringUtils.camelName(tempStr);
	}

	/**
	 * 功能：获得列的数据类型
	 * @param sqlType
	 * @return 数据类型字符串
	 */
	protected String sqlType2JavaType(String sqlType) {
		String columnType = sqlType.toLowerCase();
		if (columnType.startsWith("bit")) {
			return "Boolean";
		} else if (columnType.startsWith("tinyint")) {
			return "Byte";
		} else if (columnType.startsWith("smallint")) {
			return "Short";
		} else if (columnType.startsWith("int") || columnType.startsWith("mediumint")) {
			return "Integer";
		} else if (columnType.startsWith("bigint")) {
			return "Long";
		} else if (columnType.startsWith("float")) {
			return "Float";
		} else if (columnType.startsWith("decimal") || columnType.startsWith("numeric") || columnType.startsWith("real") || columnType.startsWith("money")
				|| columnType.startsWith("smallmoney") || columnType.startsWith("double")) {
			return "Double";
		} else if (columnType.startsWith("varchar") || columnType.startsWith("char") || columnType.startsWith("nvarchar") || columnType.startsWith("nchar")
				|| columnType.startsWith("text") || columnType.startsWith("longtext")) {
			return "String";
		} else if (columnType.startsWith("datetime") || columnType.startsWith("date")) {
			return "Date";
			// } else if (sqlType.toLowerCase().startsWith("image")) {
			// return "Blod";
		} else if (columnType.startsWith("timestamp")) {
			return "Timestamp";
		}
		return null;
	}

	public void setAuthorName(String authorName) {
		this.authorName = authorName;
	}

	/**
	 * outputJavaCode
	 * @param tableBean
	 */
	public abstract void outputJavaCode(TableBean tableBean);
}
