package com.cftech.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.order.model.*;
import com.cftech.order.dao.OrderMapper;
import com.cftech.order.service.OrderService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.PUT;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 订单管理ServiceImpl
 *
 * @author Licc
 * @date: 2020-10-10 14:20
 */
@Service("orderService")
public class OrderServiceImpl extends GenericServiceImpl<Order> implements OrderService {

    @Autowired
    @Qualifier("orderMapper")
    private OrderMapper orderMapper;

    @Override
    public GenericDao<Order> getGenericMapper() {
        return orderMapper;
    }

    @Override
    public List<Order> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize, String id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        if (!StringUtils.equals(id, "1")) {
            params.put("id", id);
        }

        return orderMapper.fetchSearchByPage(params);
    }

    @Override
    public List<ProductOrder> listProduct() {
        return orderMapper.listProduct();
    }

    @Override
    public OrderFromVO fetchId(Serializable id) {
        return orderMapper.fetchId(id);
    }

    @Override
    public List<OrderFromVO> fetchProductId(Serializable id) {
        return orderMapper.fetchProductId(id);
    }

    @Override
    public Integer updateStatus(Long id) {
        return orderMapper.updateStatus(id);
    }

    @Transactional
    @Override
    public com.alibaba.fastjson.JSONObject newlyAdded(String datas, Long accountsId) {
        com.alibaba.fastjson.JSONObject rtnJson = new com.alibaba.fastjson.JSONObject();
        OrderDetailDto orderDetailDto = null;
        Map<String, Object> params = new HashMap<String, Object>();
        datas = datas.replaceAll("&quot;", "\"");
        JSONArray jsonArray = JSONArray.fromObject(datas);

        try {
            if (jsonArray.size() > 0) {
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    long id = jsonObject.getLong("id");
                    String idDetail = jsonObject.getString("idDetail");
                    long productId = jsonObject.getLong("productId");
                    long drugsNum = jsonObject.getLong("drugsNum");
                    double price = jsonObject.getDouble("price");
                    double amount = jsonObject.getDouble("amount");
                    double orderAmount = jsonObject.getDouble("orderAmount");
                    params.put("id", id);
                    params.put("accountsId", accountsId);
                    params.put("productId", productId);
                    params.put("drugsNum", drugsNum);
                    params.put("price", price);
                    params.put("amount", amount);
                    params.put("orderAmount", orderAmount);
                    params.put("idDetail", idDetail);
                    if(!"".equals(idDetail)){
                    orderMapper.updateDetill(params);
                        rtnJson.put("errorNo","0");
                    }else {
                        ProductDto productDtos = orderMapper.fetchProduct(params);
                        orderDetailDto = new OrderDetailDto();
                        Order orders = orderMapper.fetchOrder(id);
                        orderDetailDto.setOrderCode(orders.getNumber());
                        orderDetailDto.setOrderId(id);
                        orderDetailDto.setDrugsId(productDtos.getId());
                        orderDetailDto.setOpenid(orders.getOpenid());
                        orderDetailDto.setPrice(productDtos.getPrice());
                        orderDetailDto.setAmount(amount);
                        orderDetailDto.setDrugsNum(drugsNum);
                        orderDetailDto.setDrugsCode(productDtos.getProductNumber());
                        orderDetailDto.setDrugsSku(productDtos.getFormat());
                        orderDetailDto.setAccountsId(accountsId);
                        Integer detill = orderMapper.saveDetill(orderDetailDto);
                        if (detill<0){
                            rtnJson.put("errorNo","1");
                            rtnJson.put("errorNo","修改失败");
                        }else {
                            if (detill > 0) {
                                Integer integer = orderMapper.updateOrder(params);
                                if (integer > 0) {
                                    rtnJson.put("errorNo", "0");
                                    rtnJson.put("errorMsg", "修改成功");
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
        }
        return rtnJson;

    }

    @Override
    public com.alibaba.fastjson.JSONObject deleteAll(Long id) {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        Integer integer = orderMapper.deleteAll(id);
        if (integer<0){
            jsonObject.put("errorNo","1");
        }
        jsonObject.put("errorNo","0");
        return jsonObject;
    }

    @Override
    public com.alibaba.fastjson.JSONObject confirm(String openid,Long status,Long id) {
        com.alibaba.fastjson.JSONObject rtnJson = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject object = new com.alibaba.fastjson.JSONObject();
        try {
            List<OrderMobile> orderMobiles = orderMapper.orderFall(openid, status, id);
            for (OrderMobile orderMobile : orderMobiles) {
                Long mobileId = orderMobile.getId();
                if (mobileId!=null){
                    List<ProductMobile> mobiles = orderMapper.orderDetill(mobileId);
                    orderMobile.setProductMobile(mobiles);
                }
            }
            //com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(orderMobiles));
            object.put("orderMobiles", orderMobiles);
            rtnJson.put("errorNo","0");
            rtnJson.put("data",object);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo", "1");

        }
        return rtnJson;
    }

    @Override
    public com.alibaba.fastjson.JSONObject orderSize(String openid) {
         com.alibaba.fastjson.JSONObject rtnJson = new com.alibaba.fastjson.JSONObject();
         try{
              OrderSizeVO productMobiles = orderMapper.orderSize(openid);
              if (productMobiles!=null){
                  rtnJson.put("errorNo","0");
                  rtnJson.put("data",productMobiles);
                  return  rtnJson;
              }
             rtnJson.put("errorNo","1");
         }catch (Exception e){
             e.printStackTrace();
             rtnJson.put("errorNo", "1");
         }
        return rtnJson;
    }

}