package com.cftech.module.activity.core.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.module.activity.core.model.ActivityBaseResultDto;
import com.cftech.module.activity.core.model.ActivityBaseResultEntity;

import java.util.List;
import java.util.Map;

/**
 * Created by liuling on 2017/4/18.
 * 活动中奖的Service类
 */
public interface ActivityBaseResultService extends GenericService<ActivityBaseResultEntity> {

    /**
     * 中奖记录
     * @param accountsId 所属微信账号Id
     * @param from      活动来源
     * @param activityId 活动的Id
     * @param title 主题
     * @param openId    用户的OpenId
     * @param prize 奖项名称
     * @param qty   数量
     * @param prizeDetail   奖项详情
     * @param prizeType 奖项类型
     * @param prizeAmount   奖项金额
     */
    void prizeLog(Long accountsId, String from, Long activityId, String title, String openId, String prize, int qty, String prizeDetail, String prizeType, String prizeAmount,Long meetingId);

    /**
     * 导出
     *
     * @return
     */
    List<ActivityBaseResultDto> fetchSearchByPageExport(Conds conds, Sort sort, int page, int pageSize);

    List<ActivityBaseResultEntity> selectmywin(Conds conds, Sort sort, int page, int pageSize);
}
