package com.cftech.accounts.service.impl;

import com.cftech.accounts.dao.MpAccountsMapper;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
@Service
public class MpAccountsServiceImpl extends GenericServiceImpl<MpAccountsEntity> implements MpAccountsService{

	@Autowired
	private MpAccountsMapper accountsMapper;
	
	@Override
	public List<MpAccountsEntity> getMpAccounts(Long userid) {
		return accountsMapper.getMpAccounts(userid);
	}

	@Override
	public List<MpAccountsEntity> getQyAccounts(Long userid) {
		return accountsMapper.getQyAccounts(userid);
	}

	@Override
	public List<MpAccountsEntity> getAllAccounts(Long userid) {
		return accountsMapper.getAllAccounts(userid);
	}


	@Override
	public long insert(MpAccountsEntity model) {
	        return accountsMapper.insert(model);
	}

	@Override
	public void updateByPrimaryKey(MpAccountsEntity mpAccounts) {
		accountsMapper.updateByPrimaryKey(mpAccounts);
	}

	@Override
	public int deleteByPrimaryKey(Long id) {
		return accountsMapper.deleteByPrimaryKey(id);
	}

	@Override
	public MpAccountsEntity getDetail(Long id) {
		return accountsMapper.getDetail(id);
	}

	@Override
	public List<MpAccountsEntity> getAllMpAccounts() {
		// TODO Auto-generated method stub
		return accountsMapper.getAllMpAccounts();
	}

	@Override
	public List<MpAccountsEntity> getAllQpAccounts() {
		return accountsMapper.getAllQyAccounts();
	}

	@Override
	protected GenericDao<MpAccountsEntity> getGenericMapper() {
		return accountsMapper;
	}


	@Override
	public MpAccountsEntity getMpAccountsAppid(String appId) {
		return accountsMapper.getMpAccountsAppid(appId);
	}




	@Override
	public int insertUserAccounts(Map<String, Object> params) {
		return accountsMapper.insertUserAccount(params);
	}


	@Override
	public int deleteByUserAccount(Map<String, Object> params) {
		return accountsMapper.deleteByUserAccount(params);
	}


	@Override
	public int getUserAccounts(Map<String, Object> params) {
		return accountsMapper.getUserAccounts(params);
	}
}
