/**
 * Created by liuling on 16/8/17.
 * 所有页面初始化必须先使用它的初始化
 * 给公众号用的
 */
var cfApp = (function () {
    //'use strict';

    var CfApp = function (params) {

        var p = this;
        var baseUri = G.baseUri();
        p.WXSDK_API = baseUri + '/mobile/wxjs/signature';
        // 一天的毫秒数
        p.ONE_DAY_SECONDS = 86400000;
        //跳转的其他链接
        p.OAUTH2_URL = 'https://www.michang-tech.com.cn/'+baseUri+'/static/mp/dc/oauth2.html';
        //p.OAUTH2_URL = 'https://mp.wx-schaeffler.cn/'+baseUri+'/static/mp/dc/oauth2.html';
        p.OAUTH_URL = baseUri + '/mobile/wxjs/oauth';

        // TODO 需要替换
        p.registerHtml = baseUri + "/static/mp/aidea/invitation-code.html";

        //当前的用户信息
        p.mpInfoObj = null;

        p.storeItemName = '';

        p.initOk = false;

        p.url = window.location.href.split("&code")[0];


        /**
         * 参数定义
         * @param appid 公众号的Id
         * @param registertype 如果是register则使用userinfo的授权，否则使用base的授权
         * @param code 认证的code
         * @param devMode 是否是开发模式,开发模式则使用模拟数据
         * @param errorPage 认证出错后的跳转页面
         * @param nextAction 初始化完成以后,则执行nextAction的function
         * @param initWxApi 是否需要初始化wxsdk
         * @param vt 访问时间 一般使用new Date().getTime(),防止缓存不刷新页面
         *
         */
        p.params = {
            appid: '',
            registertype: '',
            code: '',
            devMode: false,
            errorPage: '',
            nextAction: null,
            initWxApi: false,
            vt: ''
        };

        for (var param in params) {
            p.params[param] = params[param];
        }


        /**
         * 获取URL的参数内容
         * @param name
         * @returns 参数内容字符串
         */
        var getQueryString = function (name) {
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
            var r = window.location.search.substr(1).match(reg);
            if (r != null) return decodeURI(r[2]);
            return null;
        };

        /**
         * 获取URL的参数内容的功能输出
         * @param name
         * @returns 参数内容字符串
         */
        p.getQueryString = function (name) {
            return getQueryString(name);
        };

        /**
         * 跳转注册引导页
         */
        p.jumpToRegister=function () {
            return jumpToRegister();
        }

        /**
         * 判断appid字段
         * @returns 是否appid有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 获取app的值
         * @returns {string}
         */
        p.getAppId = function () {
            return p.params.appid;
        };


        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = getQueryString('appid');
                p.params.code = getQueryString('code');
            }

            p.params.code = getQueryString('code');
            // p.params.registertype = getQueryString('registertype');
            return validAppField();
        };


        /**
         * 初始化页面或应用的方法
         * @returns 初始化是否成功
         */
        p.init = function () {
            if (initBaseFields()) {
                p.storeItemName = 'mpInfo-' + p.params.appid;
                if (p.params.devMode) {
                    mockdata();
                    handleNextAction();
                } else {
                    // 对浏览器的UserAgent进行正则匹配，不含有微信独有标识的则为其他浏览器
                    // var useragent = navigator.userAgent;
                    // if (useragent.match(/MicroMessenger/i) != 'MicroMessenger') {
                    //     // 这里警告框会阻塞当前页面继续加载
                    //     alert('已禁止本次访问：您必须使用微信内置浏览器访问本页面！');
                    //     // 以下代码是用javascript强行关闭当前页面
                    //     var opened = window.open('about:blank', '_self');
                    //     opened.opener = null;
                    //     opened.close();
                    // }
                    codeHandler();
                }

                if (p.params.initWxApi) {
                    initWeiXinSDK();
                }
                return true;

            } else {
                return false;
            }
        };

        var mockdata = function () {
            var ss = {
                "oauthDate": new Date().getTime(),
                "openId": "orLRi0fh8A2wsAuqpKieKHpW__DU",
                "memberId": 371,
                "memberName": "是我",
                "imageUrl": "http://wx.qlogo.cn/mmopen/nJJte7lQ4ObLNq2aB9fZNsibugTZhovktJn2SicxYxXJWSy53WMesyQTp9zzSeS034ibXkGezna2icKvC9TOroBAFeS0jsZ6qEpf/0",
                "accountsId":348
            };
            localStorage.setItem(p.storeItemName, JSON.stringify(ss));
            p.mpInfoObj = ss;
        };


        function initWeiXinSDK() {
            var obj = {
                appid: p.params.appid
            };
            $.getJSON(p.WXSDK_API, obj, function (data) {
                initWeiXinAPI(p.params.appid, data.timestamp, data.nonceStr, data.signature);
            });

        }

        function initWeiXinAPI(appId, timestamp, noncestr, jsticket) {
            wx.config({
                debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
                appId: appId,
                timestamp: parseInt(timestamp), // 必填，生成签名的时间戳
                nonceStr: noncestr, // 必填，生成签名的随机串 wxfdb9fde3bc87db72
                signature: jsticket, // 必填，签名，见附录1
                jsApiList: ['checkJsApi', 'onMenuShareTimeline',
                    'onMenuShareAppMessage', 'onMenuShareQQ',
                    'onMenuShareWeibo', 'hideMenuItems', 'showMenuItems',
                    'hideAllNonBaseMenuItem', 'showAllNonBaseMenuItem',
                    'translateVoice', 'startRecord', 'stopRecord',
                    'onRecordEnd', 'playVoice', 'pauseVoice', 'stopVoice',
                    'uploadVoice', 'downloadVoice', 'chooseImage',
                    'previewImage', 'uploadImage', 'downloadImage',
                    'getNetworkType', 'openLocation', 'getLocation',
                    'hideOptionMenu', 'showOptionMenu', 'closeWindow',
                    'scanQRCode', 'chooseWXPay', 'openProductSpecificView',
                    'addCard', 'chooseCard', 'openCard'
                ]
                // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
            });
            wx.error(function (res) {
                console.log(res);
                // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
                // 				var mo2 = new modal({
                // 					title: res,
                // 					btnAction: success
                // 					});
                // 				mo2.alert();
                // 				function success() {
                // 					console.log('click ok');
                // 				};
            });
            wx.ready(function () {
                p.initOk = true;
                handleNextAction();
            });
        }

        /**
         * 输出当前人员的JSON对象
         * @returns {*|null}
         */
        p.getMpInfo = function () {
            return p.mpInfoObj || null;
        };

        /**
         * 输出基础的app和tokenId的对象
         * @returns {{app: string, tokenId: string}}
         */
        p.getBaseObj = function () {
            var formdata = {
                appid: p.params.appid
            };
            return formdata;
        };


        p.switchToregisterHtml = function () {
            var mo = new modal({
                title: '未注册，点击去注册',
                btnAction: function () {
                    jumpToRegister();
                },
                btnCancelAction: function () {

                }
            });
            mo.confirm();
        };


        /**
         * 效验当前LocalStorage中的mpInfo是否是可用的
         * @returns LocalStorage中的mpInfo是否是可用的
         */
        var mpStorageValid = function () {
            var mpInfo = localStorage.getItem(p.storeItemName);
            //是否有数据
            if (!mpInfo || mpInfo == "") {
                return false;
            }
            //数据是否完整
            var mpInfoObj = JSON.parse(mpInfo);
            var mp_OpenId = mpInfoObj['openId'];
            if (!mp_OpenId || mp_OpenId == '') {
                return false;
            }
            //判断localstorage中的信息是否过期 是否即将在30分钟内过期
            var currentTime = new Date().getTime();
            if ( (currentTime - parseInt(mpInfoObj['oauthDate']) > p.ONE_DAY_SECONDS )) {
                return false;
            }

            p.mpInfoObj = mpInfoObj;
            return true;
        };

        var jumpToRegister = function () {
            localStorage.clear();
            window.location.href = p.registerHtml + "?appid=" + p.params.appid + "&redirect_uri=" + encodeURIComponent(p.url) + "&registertype=register";
        };

        var handleNextAction = function () {
            console.log("empInfo:"+JSON.stringify(p.mpInfoObj))
            if (p.mpInfoObj.memberId == '') {
                if (p.params.registertype == "register") {  //进入的页面需要注册  跳转到注册页面
                    jumpToRegister();
                }
            }


            if (p.params.initWxApi) {
                if (p.initOk) {
                    if (p.params.nextAction != null) {
                        $(".showData").show();
                        p.params.nextAction(p);
                    }
                }
            } else {
                if (p.params.nextAction != null) {
                    $(".showData").show();
                    p.params.nextAction(p);
                }
            }

        };
        /**
         * 处理code
         */
        var codeHandler = function () {
            var flag = true;
            // 判断是否带有code参数
            if (!p.params.code || p.params.code == '') {
                if (mpStorageValid()) {
                    // 回调nextAction的问题
                    handleNextAction();
                } else {
                    //oauth认证
                    oauthAction();
                }
            } else {
                if (mpStorageValid()) {
                    // 回调nextAction的问题
                    handleNextAction();
                } else {
                    var formdata = {
                        appid: p.params.appid,
                        code: p.params.code,
                        vt: new Date().getTime()
                    };

                    // 请求后台处理OAUTH认证
                    $.ajax({
                        type:"post",
                        url:p.OAUTH_URL,
                        data: formdata,
                        success: function(data){
                            if (data.errorCode == '0') {
                                var oauth = data['oauth'];
                                var mpInfo = {
                                    "oauthDate": new Date().getTime(),
                                    "openId": data.openId,
                                    "memberId": data.memberUid,
                                    "accountsId": data.accountsId,
                                    "signature":data.signature,
                                    "requestId":data.requestId,
                                    "imageUrl":data.imageUrl,
                                    "key":data.key
                                };
                                p.mpInfoObj = mpInfo;//最新信息交给mpInfoJson，防止当前页面授权后，需要用到mpInfoJson的数据，无法取到

                                localStorage.setItem(p.storeItemName, JSON.stringify(mpInfo));
                                // 回调nextAction的问题
                                handleNextAction();
                            } else if (data.errorCode == '1') {
                                var mpInfo = {
                                    "oauthDate": new Date().getTime(),
                                    "openId": data.openId,
                                    "memberId": "",
                                    "accountsId": data.accountsId,
                                    "signature":data.signature,
                                    "requestId":data.requestId,
                                    "imageUrl":data.imageUrl,
                                    "key":data.key
                                };
                                p.mpInfoObj = mpInfo;
                                localStorage.setItem(p.storeItemName, JSON.stringify(mpInfo));
                                handleNextAction();
                            } else if (data.errorCode == '3') {
                                window.location.href = p.url;
                            } else {
                                // 如果请求不成功,则跳转到错误的页面
                                location.href = p.params.errorPage;
                            }
                        },
                        dataType: "json",
                        error:function(res){
                            console.log(res);
                        }
                    });
                }
            }
        };

        /**
         * 认证的链接
         */
        var oauthAction = function () {
            var scope = "snsapi_userinfo";
            // if (p.params.registertype == "register") {//注册使用userinfo授权
            //     scope = "snsapi_userinfo";
            // } else {
            //     scope = "snsapi_base";
            // }
            var oauth2Url = p.OAUTH2_URL+"?appid="+p.params.appid+"&redirect="+encodeURIComponent(p.url)+"&scope="+scope;
            //var oauth2Url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + p.params.appid + "&redirect_uri=" + encodeURIComponent(p.url) + "&response_type=code&scope=" + scope + "&state=STATE#wechat_redirect";
            // var oauth2Url = "http://mall.aosmith.com.cn/wxcode.html?appid="+GetQueryString("appid")+"&scope="+scope+"&redirect_uri="+encodeURIComponent(window.location.href);
            window.location.href = oauth2Url;
        };


    };

    return CfApp;
})();