package com.cftech.workshop.screen.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.agenda.model.Agenda;
import com.cftech.workshop.agenda.model.AgendaCustomiz;
import com.cftech.workshop.agenda.service.AgendaService;
import com.cftech.workshop.agenda_customiz.model.Agenda_customiz;
import com.cftech.workshop.agenda_customiz.service.Agenda_customizService;
import com.cftech.workshop.screen.model.Screen;
import com.cftech.workshop.screen.model.ScreenDto;
import com.cftech.workshop.screen.model.ScreenTopic;
import com.cftech.workshop.screen.service.ScreenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 投屏上传接口
 * Created by Ago on 2018/10/22.
 */
@RestController
@RequestMapping(value = "/mobile/auth/screen")
public class MobileScreenController {
    @Autowired
    private ScreenService screenService;

    @Autowired
    private Agenda_customizService agenda_customizService;

    @Autowired
    private AgendaService agendaService;

    /**
     * 添加咨询问题接口
     * @param screen
     * @return
     */
    @RequestMapping(value = "/addscreen" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addscreen(Screen screen){
        JSONObject jsonObject = new JSONObject();
        try {
            if(screen!=null){
                Boolean flag = screenService.save(screen);
                if(flag){
                    jsonObject.put("errorNo",0);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            jsonObject.put("errorNo",1);
            e.printStackTrace();
        }
        return  jsonObject;
    }

    /**
     * 获取会场接口
     * @param workshop_id 研讨会ID
     * @param accountsid
     * @return
     */
    @RequestMapping(value = "/selectcustomiz",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selectcustomiz(Long workshop_id,Long accountsid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(workshop_id))&&StringUtils.isNoneBlank(String.valueOf(accountsid))){
                Conds conds = new Conds();
                conds.equal("workshop_id",workshop_id);
                conds.equal("del_flag",0);
                conds.equal("accounts_id",accountsid);
                Sort sort = new Sort("sort", OrderType.ASC);
                List<Agenda_customiz> agenda_customiz = agenda_customizService.fetchSearchByPage(conds,sort,0,0);
                if(agenda_customiz.size()>0){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",agenda_customiz);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 查询主题接口
     * @param customiz_id 会场名称
     * @param meetingId 研讨会ID
     * @return
     */
    @RequestMapping(value = "/selecttopic",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject selecttopic(String customiz_id,Long meetingId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                Conds conds = new Conds();
                if(StringUtils.isNoneBlank(customiz_id)){
                    conds.equal("a.workshop_id",meetingId);
                    conds.equal("a.del_flag",0);
                    conds.equal("c.id",customiz_id);
                }else{
                    conds.equal("a.workshop_id",meetingId);
                    conds.equal("a.del_flag",0);
                }
                List<AgendaCustomiz> list = agendaService.agendaCustomizs(conds, null, 0, 0);
                if(list.size()>0&&list!=null){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",list);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

    /**
     * 判断会场是否开放
     * @param customizId 会场ID
     * @return
     */
    @RequestMapping(value = "/customizbyid",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject customizbyid(Long customizId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(customizId))){
                Conds conds = new Conds();
                conds.equal("a.customiz_id",customizId);
                conds.equal("a.del_flag",0);
                conds.equal("a.status",1);
                List<ScreenTopic> list = screenService.selectscreentopic(conds,null,0,0);
                if(list.size()>0){  //会场以开放
                    for(ScreenTopic screenTopic:list){
                        jsonObject.put("errorNo",0);
                        jsonObject.put("data",screenTopic);
                    }
                }else{
                    jsonObject.put("errorNo",3);  //未开放
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }

}
