package com.cftech.mp.reply.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * wx_mp_reply 实体类
 * Created by lisw 27/10/2016.
 */ 
@Data
@NoArgsConstructor
public class Reply implements Serializable {
	/**
	 * id
	 */
	private Long id;

	/**
	 * 消息类型 text:文字 image:图片 subscribe:关注 qrscene:二维码关注 keyword：关键字
	 */
	private String sendType;

	/**
	 *sendType为keyword时，keyword字段存在
	 */
	private String keyword;

	/**
	 * 关键字是否完全匹配
	 */
	private String keywordIsAll;

	/**
	 * 回复内容 text:文字 news:图文
	 */
	private String replyType;

	/**
	 * 回复内容  replyType:text,source为文字回复,replyType:news,source为图文ID集合。
	 */
	private String contentSource;

	/**
	 * createtime
	 */
	private Timestamp createtime;

	/**
	 * updatetime
	 */
	private Timestamp updatetime;

	/**
	 * createBy
	 */
	private Long createBy;

	/**
	 * updateBy
	 */
	private Long updateBy;

	/**
	 * delflag
	 */
	private String delflag;
	
	/**
	 * accountsid
	 */
	private Long accountsid;

	/**
	 *
	 * 辅助字段  图文素材JSON
	 */
	private String newsItem;




}