package com.cftech.cms.cfarticle.service;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;

/**
* CMS文章管理Service
*
* @author lisw
* @date: 2017-05-03 10:51
*/
public interface CfarticleService extends GenericService<Cfarticle> {

    /**
     * 分页查询
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<CfarticleColumnDto> fetchSearchByPageTemp(Conds conds, Sort sort, int page, int pageSize,Long specialId);



    /**
     * 查询总条数
     *
     * @param conds 条件
     * @return 条数
     */
    int countTemp(Conds conds);
    JSONObject selectYes();
    JSONObject selectBanner();
    List<Cfarticle> fetchSearchByPageInOrder(Conds conds,String articles);

    int countReview(Conds conds);
    JSONObject updatecom(String datas);
    /**
     * @Author Licc
     * @Description  药品库推荐数据回填
     * @Date 17:24 2020/10/28
     * @Param  
     * @return 
     **/
    JSONObject recommended(Long id,String appId);
    /**
     * @Author Licc
     * @Description  阅读量
     * @Date 18:33 2020/10/28
     * @Param
     * @return
     **/
    JSONObject reading(Long id,String appId);
    /**
     * @Author Licc
     * @Description  门户列表数据回填
     * @Date 10:34 2020/10/30
     * @Param
     * @return
     **/
    JSONObject  geteway(String title,String appId,Long page,Long pageSize);
    /**
     * @Author Licc
     * @Description 栏目列表列表数据回填
     * @Date 10:34 2020/10/30
     * @Param
     * @return
     **/
    JSONObject  column(String appId);
    /**
     * @Author Licc
     * @Description 栏目文章详情
     * @Date 10:34 2020/10/30
     * @Param
     * @return
     **/
    JSONObject  columnDetails(Long id,String appId,Long page,Long pageSize,String title);
}
