package com.cftech.workshop.speech.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.speech.model.Speech;
import com.cftech.workshop.speech.service.SpeechService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.owasp.esapi.ESAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SPEECH_VIEW = "qy:speech:view"
 * 查看:public static final String SPEECH_EDIT = "qy:speech:edit"
 *
 * @author byj
 * @date: 2018-06-29 14:18
 */
@Slf4j
@Controller
@RequestMapping("/a/speech")
public class SpeechController {

    public static final String SPEECH_VIEW = "qy:speech:view";
    public static final String SPEECH_EDIT = "qy:speech:edit";

    @Autowired
    private SpeechService speechService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private MeetingService meetingService;


    //列表页面
    @RequiresPermissions(value = SPEECH_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model,Long meetingId) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("meetingId",meetingId);
        return "speech/speechlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SPEECH_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model,Long meetingId) {
        if (!StringUtils.isEmpty(id)) {
            Speech speech = speechService.fetchById(id);
//            speech.setContent_speech(HtmlUtils.htmlEscape(speech.getContent_speech()));
//            speech.setContent_speech_en(HtmlUtils.htmlUnescape(speech.getContent_speech_en()));
            speech.setContent_speech(ESAPI.encoder().decodeForHTML(speech.getContent_speech()));
            speech.setContent_speech_en(ESAPI.encoder().decodeForHTML(speech.getContent_speech_en()));
            model.addAttribute("data", speech);
        }
        model.addAttribute("meetingId",meetingId);
        return "speech/speechform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SPEECH_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Speech speech, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (speech != null && speech.getId() != null) {
                speech.setUpdateBy(UserUtils.getUser().getId());
                speechService.update(speech);
                rtnJson.put("errorNo", 0);
            } else {
                speech.setNumber(codingruleUtils.getNumber(accountsId, Speech.class.getName()));
                speech.setAccountsId(accountsId);
                speech.setDelFlag(false);
                speech.setAccountsId(UserUtils.getmpaccounts(request));
                speech.setCreateBy(UserUtils.getUser().getId());
                speech.setUpdateBy(UserUtils.getUser().getId());
                speech.setClicks(Long.valueOf(0));
                speechService.save(speech);
                meetingService.synMobileMenu();
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SPEECH_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Speech speech, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(speech.getNumber())) {
            conds.like("number", speech.getNumber());
        }
        if (!StringUtils.isEmpty(speech.getSpeech_name())) {
            conds.like("speech_name", speech.getSpeech_name());
        }
        if (!StringUtils.isEmpty(speech.getSpeech_name_en())) {
            conds.like("speech_name_en", speech.getSpeech_name_en());
        }
        if (!StringUtils.isEmpty(speech.getSpeech_describe())) {
            conds.like("speech_describe", speech.getSpeech_describe());
        }
        if (!StringUtils.isEmpty(speech.getSpeech_describe_en())) {
            conds.like("speech_describe_en", speech.getSpeech_describe_en());
        }
        if (!StringUtils.isEmpty(speech.getWorkshop_id())) {
            conds.equal("workshop_id", speech.getWorkshop_id());
        }
        if (!StringUtils.isEmpty(speech.getContent_speech_en())) {
            conds.equal("content_speech_en", speech.getContent_speech_en());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<Speech> list = speechService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = speechService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SPEECH_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            speechService.delete(id);
            meetingService.synMobileMenu();
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }

        return rtnJosn;
    }

}
