package com.cftech.brand.util;

import com.cftech.brand.apply.model.BrandApply;
import com.cftech.brand.manager.model.BrandManager;
import com.cftech.core.util.DateUtils;
import com.cftech.core.util.SystemConfig;
import org.mp.api.wxsendmsg.JwTemplateMessageAPI;

import java.util.Date;

/**
 * 品牌申请模板消息工具类
 * @author faye
 * @date 2020-02-12
 */
public class BrandApplyTempMsgUtil {
    //域名
    static String baseUri = SystemConfig.p.getProperty("QY_DOMAIN_NAME");

    //APPID
    static String appid = SystemConfig.p.getProperty("WX_MP_SERVER_APPID");


    private static final String title="品牌服务";

    //申请人提交成功
    private static final String submittedTempId=SystemConfig.p.getProperty("brandApplySubmittedTempId");

    //管理员接单
    private static final String managerAgreedTempId=SystemConfig.p.getProperty("brandApplyManagerAgreedTempId");

    //共用的模板消息id
    private static final String commTemplateId=SystemConfig.p.getProperty("brandApplyCommTemplateId");

    //取消模板消息id
    private static final String canceledTemplateId=SystemConfig.p.getProperty("brandApplyCanceledTemplateId");

    //管理员设置完工的消息提醒
    private static final String completedTemplateId=SystemConfig.p.getProperty("brandApplyCompletedTemplateId");
    //申请单详情地址
    private static final String detailUri = baseUri +"/static/mp/schaeffler/wx-brand-detail.html?appid="+appid + "&id=";
    //评分地址
    private static final String appraiselUri = baseUri +"/static/mp/schaeffler/wx-appraise.html?appid="+appid + "&id=";


    /**
     * 品牌申请申请人提交提醒申请人提交成功
     * @param token
     */
    public static void sendMsgToApplicantBySubmit(Long id,String name,String number,String openId,Date createTime,String contactEmp,String contactInformation,String token){
        String first="尊敬的"+name+"，您的申请已经提交成功，请等待接单。";
//        String keyword1="品牌服务( 联系人 "+contactEmp+" 电话"+contactInformation+" )";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String remarks="点击查看申请单详情。";
        String[] keyword = {keyword1,keyword2};
        JwTemplateMessageAPI.sendMessage(submittedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }
    /**
     * 品牌申请申请人提交提醒管理员
     * @param token
     */
    public static void sendMsgToManagerBySubmit(Long id,String number,String openId,Date createTime,String token){
        String first="尊敬的管理员，您收到一份申请，请处理需求。";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String remarks="点击查看申请单详情。";
        String[] keyword = {keyword1,keyword2};
        JwTemplateMessageAPI.sendMessage(submittedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 品牌申请申请人修改提醒管理员
     * @param token
     */
    public static void sendMsgToManagerByUpdate(Long id,String name,String number,String openId,Date createTime,String token){
        String first="尊敬的管理员,"+name+"已更新需求，请处理需求。";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String remarks="点击查看申请单详情。";
        String[] keyword = {keyword1,keyword2};
        JwTemplateMessageAPI.sendMessage(submittedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 品牌申请申请人提交提醒申请人修改成功
     * @param token
     */
    public static void sendMsgToApplicantByUpdate(Long id,String name,String number,String openId,Date createTime,String contactEmp,String contactInformation,String token){
        String first="尊敬的"+name+"，您的需求已更新请等待接单。";
//        String keyword1="品牌服务( 联系人 "+contactEmp+" 电话"+contactInformation+" )";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String remarks="点击查看申请单详情。";
        String[] keyword = {keyword1,keyword2};
        JwTemplateMessageAPI.sendMessage(submittedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }


    /**
     * 申请人取消通知申请人
     * @param token
     */
    public static void sendMsgToApplicantByCanceled(Long id,String name,String number,String openId,Date createTime,String token){
        String first="尊敬的"+name+"，您的需求已取消（工单编号："+number+"）。";
        String keyword1="品牌服务";
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String keyword3=DateUtils.formatDate(new Date(),"yyyy-MM-dd HH:ss");
        String remarks="点击查看该申请单详情。";
        String[] keyword = {keyword1,keyword2,keyword3};
        JwTemplateMessageAPI.sendMessage(canceledTemplateId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 申请人取消通知申请人
     * @param token
     */
    public static void sendMsgToManagerByCanceled(Long id,String name,String number,String openId,Date createTime,String token){
        String first="尊敬的管理员,"+name+"已取消需求（工单编号："+number+"）。";
        String keyword1="品牌服务";
        String keyword2=DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss");
        String keyword3=DateUtils.formatDate(new Date(),"yyyy-MM-dd HH:ss");
        String remarks="点击查看该申请单详情。";
        String[] keyword = {keyword1,keyword2,keyword3};
        JwTemplateMessageAPI.sendMessage(canceledTemplateId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 邀请申请人确认拟交付详情
     * @param token
     */
    public static void sendMsgByEmpToBeConfirm(Long id,String name,String number,String openId,Date operateDate,String contactEmp,String contactInformation,String token){
        String first="尊敬的"+name+"，您的申请已被接受。";
//        String keyword1="品牌服务( 联系人 "+contactEmp+" 电话"+contactInformation+" )";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(operateDate,"yyyy-MM-dd HH:ss");
        String keyword3="待申请人确认拟交付详情";
        String remarks="点击确认↓↓↓";
        String[] keyword = {keyword1,keyword2,keyword3};
        JwTemplateMessageAPI.sendMessage(managerAgreedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 申请人确认拟交付详情通知管理员
     * @param token
     */
    public static void sendMsgByEmpToBeConfirmForManager(Long id,String name,String number,String openId,Date operateDate,String contactEmp,String contactInformation,String token){
        String first="尊敬的管理员，"+name+"已确认品牌服务需求。";
//        String keyword1="品牌服务( 联系人 "+contactEmp+" 电话"+contactInformation+" )";
        String keyword1=number;
        String keyword2=DateUtils.formatDate(operateDate,"yyyy-MM-dd HH:ss");
        String keyword3="待市场部领导审批";
        String remarks="点击查看申请单详情。";
        String[] keyword = {keyword1,keyword2,keyword3};
        JwTemplateMessageAPI.sendMessage(managerAgreedTempId, token,
                openId, first, remarks, keyword, detailUri+id);
    }

    /**
     * 发送模板消息给管理员（根据拟交付日期）
     * @param manager
     * @param brandApply
     * @param token
     */
    public static void sendTemplateMsgByIntendedDeliveryDate(BrandManager manager, BrandApply brandApply,String token){
        String first="尊敬的管理员，"+ DateUtils.formatDate(brandApply.getIntendedDeliveryDate(),"yyyy年MM月dd日")+"是工单（编号："+brandApply
                .getNumber()+"）交付日，请确保及时交付，如已完成，请更新工单状态，并提交评价。";
        String keyword2=DateUtils.formatDate(brandApply.getCreateTime(),"yyyy-MM-dd HH:ss");
        String remarks="点击查看申请单详情。";
        String[] keyword = {title,keyword2};
        JwTemplateMessageAPI.sendMessage(commTemplateId, token,
                manager.getOpenId(), first, remarks, keyword, detailUri+brandApply.getId());
    }

    /**
     * 发送评分邀请给申请人(完工后)
     */
    public static void sendTemplateMsgByComplte(Long id,String token,String openId,String name,String number,String serviceEmpName,String serviceEmpMobile){
        String first="尊敬的"+name+"，您的需求已完成交付，我们期待您的评价和建议。";
        String remarks="点击详情提交您的反馈。";
        String[] keyword = {number,"品牌服务"};
        JwTemplateMessageAPI.sendMessage(completedTemplateId, token,
                openId, first, remarks, keyword, appraiselUri+id);
    }

    /**
     * 市场部领导确认拟交付详情后，通知后台管理员
     */
    public static void sendToManagerByMarketConfirm(Long id,String token,String openId,String number,Date createTime){
        String first="尊敬的管理员，市场部领导已确认品牌服务申请（工单编号："+number+"），请尽快推进后续工作，确保交付。";
        String remarks="请安排后续工作，点击查看申请单详情。";
        String[] keyword = {title,DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss")};
        JwTemplateMessageAPI.sendMessage(commTemplateId, token,
                openId, first, remarks, keyword, detailUri+id);
    }
    /**
     * 市场部领导确认拟交付详情后，通知申请人
     */
    public static void sendToApplicantByMarketConfirm(Long id,String token,String openId,String name,String number,String serviceEmpName,String serviceEmpMobile,Date createTime){
        String first="尊敬的"+name+"，您的品牌服务需求已确认（工单编号："+number+"）。";
        String remarks=serviceEmpName+" （电话"+serviceEmpMobile+"）将为您提供支持，点击查看申请单详情。";
        String[] keyword = {title,DateUtils.formatDate(createTime,"yyyy-MM-dd HH:ss")};
        JwTemplateMessageAPI.sendMessage(commTemplateId, token,
                openId, first, remarks, keyword, detailUri+id);
    }
}
