package com.cftech.questionnaire.core.paper.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问卷记录
 *
 * @author wxf
 * @date: 2017-05-25 10:27
 */
@Data
public class PaperLog implements Serializable {

        /* 主键id */
        private Long id;
        /* 问卷ID */
        private Long paperId;
        /* 业务对象ID */
        private Long boId;
        /**
         *  提交的答案
         *  {
         *     title: 题目标题
         *     type: 题目类型
         *     options: [    选项组合
         *      {
         *          label: '标签名称 ABC 123'
         *          name: '选项名称',
         *          pic: '选项图片链接'
         *         isanswer:'0 不是 1是'
         *      }
         *     ]
         * }
         */
        private String answers;
        /* 玩家id 服务号openid 企业号userid */
        private String palyerId;
        /* 填空题填的答案 */
        private  String option_con;
        /* 题目的ID */
        private Long subject_id;
        /* 选择题答案ID */
        private Long option_id;
        /* 所属的账号 */
        private Long accountsId;
        /* 删除标识 */
        private boolean delFlag;
        /* 状态 */
        private String status;
        /* 创建时间 */
        private Date createTime;
        /* 更新时间 */
        private Date updateTime;
        /* 备注 */
        private String description;
        /* 创建人 */
        private Long createBy;
        /* 更新人 */
        private Long updateBy;

        public PaperLog() {
                this.delFlag = false;
                this.status = "0";
        }

}