package com.cftech.core.mybatis.mybatis;

import com.cftech.core.util.DateUtils;
import com.cftech.core.util.StringUtils;


/**
 * Created by lisw on 2016-08-05
 */
public class ServiceGenerator extends AbstractMybatisGenerator {

    @Override
    public void outputJavaCode(TableBean tableBean) {
        if (tableBean != null) {
            String rootPath = "";
            if (StringUtils.isBlank(rootPath)) {
                rootPath = System.getProperty("user.dir");
            }
            if (!rootPath.endsWith("/src/main/java") || !rootPath.endsWith("src/main/java/")) {
                if (rootPath.endsWith("/")) {
                    rootPath += "src/main/java/";
                } else {
                    rootPath += "/src/main/java/";
                }
            }
            String basePackage = tableBean.getBasePackage();

            String filePath = rootPath + basePackage.replace(pointStr, "/") + "/";
            String entityName = tableBean.getEntityName();
            String serviceFilePath = filePath + "service/" + entityName + "Service.java";
            String serviceImplFilePath = filePath + "service/impl/" + entityName + "ServiceImpl.java";
            String modelPackage = tableBean.getPackageName();
            // outputJavaFile(daoFilePath, generateMapper(basePackage, modelPackage, entityName).toString());

            outputJavaFile(serviceFilePath, generateService(basePackage, modelPackage, entityName).toString());
            outputJavaFile(serviceImplFilePath, generateServiceImpl(basePackage, modelPackage, entityName).toString());
        }
    }

    /**
     * generateService
     *
     * @param basePackage
     * @param modelPackage
     * @param entityName
     * @return StringBuffer
     */
    public StringBuffer generateService(String basePackage, String modelPackage, String entityName) {
        StringBuffer sb = new StringBuffer();

        String clazzSimpleName = entityName;
        String clazzNameLower = clazzSimpleName.substring(0, 1).toLowerCase() + clazzSimpleName.substring(1);

        String importString = "import ";
        String suffix = "service";
        String suffixUpper = suffix.substring(0, 1).toUpperCase() + suffix.substring(1);
        sb.append("package ").append(basePackage).append(pointStr).append(suffix).append(semicolon).append(enter);
        sb.append(enter);
        sb.append("import GenericService;").append(enter);
        sb.append(importString).append(modelPackage).append(pointStr).append(clazzSimpleName).append(semicolon).append(enter);
        sb.append(enter);
        sb.append("/**").append(enter);
        sb.append(" * ").append(clazzNameLower).append(suffixUpper).append(enter);
        // sb.append(" * @author ice").append(enter);
        sb.append(" * Created by " + this.authorName + " " + DateUtils.getDate("dd/MM/yyyy") + ".").append(enter);
        sb.append(" */").append(enter);
        sb.append("public interface ").append(clazzSimpleName).append(suffixUpper);
        sb.append(" extends GenericService<").append(clazzSimpleName).append("> {").append(enter);
        sb.append(enter);
        sb.append("}").append(enter);
        return sb;
    }

    /**
     * generateServiceImpl
     *
     * @param basePackage
     * @param modelPackage
     * @param entityName
     * @return StringBuffer
     */
    public StringBuffer generateServiceImpl(String basePackage, String modelPackage, String entityName) {
        StringBuffer sb = new StringBuffer();

        String clazzSimpleName = entityName;
        String clazzNameLower = clazzSimpleName.substring(0, 1).toLowerCase() + clazzSimpleName.substring(1);

        String packageSuffix = "service.impl";
        String suffix = "service";
        String implSuffix = "ServiceImpl";
        String suffixUpper = suffix.substring(0, 1).toUpperCase() + suffix.substring(1);
        sb.append("package ").append(basePackage).append(pointStr).append(packageSuffix).append(semicolon).append(enter);
        sb.append(enter);
        sb.append("import org.springframework.beans.factory.annotation.Autowired;").append(enter);
        sb.append("import org.springframework.beans.factory.annotation.Qualifier;").append(enter);
        sb.append("import org.springframework.stereotype.Service;").append(enter);
        sb.append(enter);
        sb.append("import GenericDao;").append(enter);
        sb.append("import GenericServiceImpl;").append(enter);
        String daoSuffix = "dao";
        String mapperSuffixUpper = "Mapper";
        String importString = "import ";
        sb.append(importString).append(basePackage).append(pointStr).append(daoSuffix).append(pointStr);
        sb.append(clazzSimpleName).append(mapperSuffixUpper).append(semicolon).append(enter);
        sb.append(importString).append(modelPackage).append(pointStr).append(clazzSimpleName).append(semicolon).append(enter);
        sb.append(importString).append(basePackage).append(pointStr).append(suffix).append(pointStr).append(clazzSimpleName);
        sb.append(suffixUpper).append(semicolon).append(enter);

        sb.append(enter);
        sb.append("/**").append(enter);
        sb.append(" * ").append(clazzNameLower).append(suffixUpper).append(enter);
        // sb.append(" * @author ice").append(enter);
        sb.append(" * Created by " + this.authorName + " " + DateUtils.getDate("dd/MM/yyyy") + ".").append(enter);
        sb.append(" */").append(enter);
        sb.append("@Service(\"").append(clazzNameLower).append(suffixUpper).append("\")").append(enter);
        sb.append("public class ").append(clazzSimpleName).append(implSuffix);
        sb.append(" extends GenericServiceImpl<").append(clazzSimpleName).append("> ");
        sb.append("implements ").append(clazzSimpleName).append(suffixUpper).append(" {").append(enter);
        sb.append(enter);

        sb.append(tab).append("/**").append(enter);
        sb.append(tab).append(" * ").append(clazzNameLower).append(mapperSuffixUpper).append(enter);
        sb.append(tab).append(" */").append(enter);
        sb.append(tab).append("@Autowired").append(enter);

        sb.append(tab).append("@Qualifier(\"").append(clazzNameLower).append("Mapper\")").append(enter);

        sb.append(tab).append("private ").append(clazzSimpleName).append(mapperSuffixUpper);
        sb.append(" ").append(clazzNameLower).append(mapperSuffixUpper).append(semicolon).append(enter);
        sb.append(enter);
        sb.append(tab).append("@Override").append(enter);
        sb.append(tab).append("public GenericDao<").append(clazzSimpleName).append("> getGenericMapper() {").append(enter);
        sb.append(tab).append(tab).append("return ").append(clazzNameLower).append(mapperSuffixUpper).append(semicolon).append(enter);
        sb.append(tab).append("}").append(enter);
        sb.append("}").append(enter);
        return sb;
    }
}
