package com.cftech.module.activity.core.model;

import com.cftech.core.poi.ExportConfig;
import com.cftech.core.util.DateUtils;
import com.cftech.core.util.StringUtils;

import java.util.Date;

/**
 * Created by lisw on 2017/5/19 0019.
 */
public class ActivityBaseResultDto {
    /**
     * 所属的账号
     */
    private Long accountsId;
    //属于哪个活动，直接从className取值
    private String from;
    //活动的Id
    private Long activityId;
    //活动名称
    @ExportConfig(value = "活动名称")
    private String title;
    //访问的openId
    @ExportConfig(value = "OPENID")
    private String openId;
    //活动的奖励
    @ExportConfig(value = "活动奖励")
    private String prize;
    //获得个数
    @ExportConfig(value = "获得个数")
    private int qty;
    //奖励的描述
    @ExportConfig(value = "奖励描述")
    private String prizeDetail;
    //奖励的类型
    @ExportConfig(value = "奖励类型")
    private String prizeType;
    //奖励的金额
    @ExportConfig(value = "奖励金额")
    private String prizeAmount;

    private Date createTime;

    @ExportConfig(value = "活动类型")
    private String fromName;


    @ExportConfig(value = "中将时间")
    private String createTimeStr;

    public Long getAccountsId() {
        return accountsId;
    }

    public void setAccountsId(Long accountsId) {
        this.accountsId = accountsId;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        if (StringUtils.isNotBlank(from)) {
            if (from.equals("Wheel")) {
                this.fromName = "大转盘";
            } else if (from.equals("Scratch")) {
                this.fromName = "刮刮卡";
            } else if (from.equals("Eggs")) {
                this.fromName = "砸金蛋";
            } else {
                this.fromName = "拆礼盒";
            }
        }
        this.from = from;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getPrize() {
        return prize;
    }

    public void setPrize(String prize) {
        this.prize = prize;
    }

    public int getQty() {
        return qty;
    }

    public void setQty(int qty) {
        this.qty = qty;
    }

    public String getPrizeDetail() {
        return prizeDetail;
    }

    public void setPrizeDetail(String prizeDetail) {
        this.prizeDetail = prizeDetail;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getPrizeAmount() {
        return prizeAmount;
    }

    public void setPrizeAmount(String prizeAmount) {
        this.prizeAmount = prizeAmount;
    }

    public String getFromName() {
        return fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        if(createTime!=null){
            this.createTimeStr = DateUtils.formatDate(createTime,"yyyy-MM-dd HH:mm");
        }
        this.createTime = createTime;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }
}
