package org.mp.api.wxstore;


import com.cftech.core.util.OKHttpUtils;
import com.cftech.core.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.mp.api.wxstore.store.WxStore;
import org.mp.api.wxstore.store.WxStoreMap;

import java.io.IOException;

/**
 * Created by lisw on 2017/7/6 0006.
 */
@Slf4j
public class WxStoreApiUtils {

    //从腾讯地图拉取省市区信息
    private static String getdistrictUrl="https://api.weixin.qq.com/wxa/get_district?access_token=";

    //在腾讯地图中搜索门店
    private static String searchStoreByMapUrl="https://api.weixin.qq.com/wxa/search_map_poi?access_token=";

    //在腾讯地图中创建门店
    private static String createStoreByMapUrl="https://api.weixin.qq.com/wxa/create_map_poi?access_token=";

    //添加门店
    private static String addStoreUrl="https://api.weixin.qq.com/wxa/add_store?access_token=";

    //更新门店信息
    private static String updateStoreUrl="https://api.weixin.qq.com/wxa/update_store?access_token=";

    //获取单个门店信息
    private static String getStoreInfoUrl="https://api.weixin.qq.com/wxa/get_store_info?access_token=";

    //获取门店列表
    private static String getStoreListUrl="https://api.weixin.qq.com/wxa/get_store_list?access_token=";

    //删除门店
    private static String delStoreUrl="https://api.weixin.qq.com/wxa/del_store?access_token=";

    /**
     * 获取腾讯省市信息
     */
    public static String getDistrict(String accessToken){
        String result="";
        String url = getdistrictUrl+accessToken;
        JSONObject paramsJson = new JSONObject();
        try {
            result = OKHttpUtils.getJSON(url);
            log.info(result);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     *在腾讯地图中搜索门店
     * @param districtid 对应拉取省市区信息接口中的id字段
     * @param keyword 搜索的关键词
     */
    private static String searchStoreByMap(String accessToken,String districtid,String keyword){
        String url=searchStoreByMapUrl+accessToken;
        String result="";
        JSONObject paramsJson=new JSONObject();
        paramsJson.put("districtid",districtid);
        paramsJson.put("keyword",keyword);
        try {
            result = OKHttpUtils.postJSON(url,paramsJson.toString());
            log.info(result);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }


    /**
     * 在腾讯地图中创建门店
     * @param accessToken
     */
    public static String createStoreByMap(String accessToken, WxStoreMap store){
        String url = createStoreByMapUrl+accessToken;
        JSONObject paramsJson = JSONObject.fromObject(store);
        JSONObject baseInfoJSON = new JSONObject();
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(url,paramsJson.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 添加门店
     * @param accessToken
     */
    public static String addStore(String accessToken, WxStore store){
        String storeUrl = addStoreUrl+accessToken;
        JSONObject paramsJson = JSONObject.fromObject(store);
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,paramsJson.toString());
            log.info(rtnJson);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 更新门店
     * @param accessToken
     */
    public static String updateStore(String accessToken, WxStore store){
         String storeUrl = updateStoreUrl+accessToken;
        JSONObject paramsJson = JSONObject.fromObject(store);
       if(StringUtils.isBlank(paramsJson.getString("pic_list"))){
           paramsJson.remove("pic_list");
       }
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,paramsJson.toString());
            log.info(rtnJson);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 删除门店
     * @param accessToken
     * @param storeId  微信门店id
     */
    public static String delStore(String accessToken, String storeId){
        String storeUrl = delStoreUrl+accessToken;
        JSONObject paramsJSON = new JSONObject();
        paramsJSON.put("poi_id",storeId);
        String rtnJson = null;
        try {
            rtnJson = OKHttpUtils.postJSON(storeUrl,paramsJSON.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return rtnJson;
    }

    public static void main(String[] args) {
        String accessToken="XDymeCTCm7qVuEOuV3GWogVcB6wGrdG_lF9D8iqyGmPIQgYKJuyXiJh2ioNQjU-0bD9PwflhXvBAqLv52PlhBZo2UsGjxsbAAtU4BSnPNWYFML3zjB3C1a2oXdzGbWlxQJQgAGAJCJ";
        System.out.println(delStore(accessToken,"480942285"));
       /* String str=delStore(accessToken,"480702249");
        System.out.println(str);*/
        /*Store store = new Store();
        store.setRecommend("123123123");
        createStore("1111",store);*/


    }


}
