package com.cftech.mp.article.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 素材管理
 *
 * @author lisw
 * @date: 2017-04-18 17:37
 */
@Data
public class MpArticle implements Serializable {

    /* 主键id */
    private Long id;
    /* 微信官方MediaId */
    @ExportConfig(value = "微信官方MediaId", width = 100)
    private String media_id;
    /* 图文列表JSON */
    @ExportConfig(value = "图文列表JSON", width = 100)
    private String news_item;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    /**
     * 微信素材最后一次更新时间
     */
    private Date wxUpdateTime;

    public MpArticle() {
        this.delFlag = false;
        this.status = "0";
    }

}