package com.cftech.addresst.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 收货地址管理
 *
 * @author Licc
 * @date: 2020-09-29 17:17
 */
@Data
public class Address extends Area implements Serializable {

    /* 主键id */
    private Long id;
    /* openId */
    @ExportConfig(value = "openId", width = 100, showLevel = 1)
    private String openId;
    /* 收货人name */
    @ExportConfig(value = "收货人name", width = 100, showLevel = 1)
    private String addressName;
    /* 详细收货地址 */
    @ExportConfig(value = "详细收货地址", width = 100, showLevel = 1)
    private String address;
    /* 省份id */
    @ExportConfig(value = "省份id", width = 100, showLevel = 1)
    private Long provinceId;
    /* 城市id */
    @ExportConfig(value = "城市id", width = 100, showLevel = 1)
    private Long cityId;
    /*  区县id*/
    @ExportConfig(value = "区县id", width = 100, showLevel = 1)
    private Long areaId;
    /* 性别 */
    @ExportConfig(value = "性别", width = 100, showLevel = 1)
    private Long sex;
    /* 手机号 */
    @ExportConfig(value = "手机号", width = 100, showLevel = 1)
    private String phone;
    /* 是否为默认地址 */
    @ExportConfig(value = "是否为默认地址", width = 100, showLevel = 1)
    private Long whether;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String appId;

    public Address() {
        this.delFlag = false;
        this.status = "0";
    }

}