package com.cftech.core.mybatis;

import com.cftech.core.mybatis.mybatis.*;
import com.cftech.core.util.StringUtils;


/**
 * Created by lisw on 2016-08-05
 */
public class MybatisCodeTools {

	/**
	 * author name
	 */
	protected String authorName;

	/**
	 * driverName
	 */
	private String driverName;

	/**
	 * dsUrl
	 */
	private String dsUrl;
	/**
	 * dsUserName
	 */
	private String dsUserName;
	/**
	 * dsPassword
	 */
	private String dsPassword;
	/**
	 * tableName
	 */
	private String tableName;

	/**
	 * 表名到实体对象 时需要去掉的前缀
	 */
	private String classNamePrefix;

	/**
	 * 实体类包名,带有model 或者是 entity
	 */
	private String packageName;

	/**
	 * mybatis 相关类的基础包名,即 dao service rest 所在包的包名
	 */
	private String basePackage;

	/**
	 * mapper开启缓存
	 */
	private Boolean withCache = false;

	/**
	 * generateJavaFile
	 */
	public void generateJavaFile() {
		boolean flag = StringUtils.isNotBlank(driverName);
		flag = flag && StringUtils.isNotBlank(dsUrl);
		flag = flag && StringUtils.isNotBlank(dsUserName);
		flag = flag && StringUtils.isNotBlank(dsPassword);
		flag = flag && StringUtils.isNotBlank(tableName);
		flag = flag && StringUtils.isNotBlank(packageName);
		flag = flag && StringUtils.isNotBlank(basePackage);
		flag = flag && StringUtils.isNotBlank(authorName);
		if (flag) {
			TableRead tableRead = new TableRead();
			tableRead.setClassNamePrefix(classNamePrefix);
			TableBean tableBean = tableRead.generateEntity(driverName, dsUrl, dsUserName, dsPassword, tableName);
			tableBean.setBasePackage(basePackage);
			tableBean.setPackageName(packageName);

			EntityGenerator entityGenerator = new EntityGenerator();
			entityGenerator.setAuthorName(authorName);
			entityGenerator.outputJavaCode(tableBean);

			MapperGenerator mapperGenerator = new MapperGenerator();
			mapperGenerator.setAuthorName(authorName);
			mapperGenerator.setWithCache(withCache);
			mapperGenerator.outputJavaCode(tableBean);

			ServiceGenerator serviceGenerator = new ServiceGenerator();
			serviceGenerator.setAuthorName(authorName);
			serviceGenerator.outputJavaCode(tableBean);
			
			ControllerGenerator controllerGenrator = new ControllerGenerator();
			controllerGenrator.setAuthorName(authorName);
			controllerGenrator.outputJavaCode(tableBean);

			/*RestControllerGenerator restControllerGenerator = new RestControllerGenerator();
			restControllerGenerator.setAuthorName(authorName);
			restControllerGenerator.outputJavaCode(tableBean);*/
		}
	}

	public void setDriverName(String driverName) {
		this.driverName = driverName;
	}

	public void setDsUrl(String dsUrl) {
		this.dsUrl = dsUrl;
	}

	public void setDsUserName(String dsUserName) {
		this.dsUserName = dsUserName;
	}

	public void setDsPassword(String dsPassword) {
		this.dsPassword = dsPassword;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public void setClassNamePrefix(String classNamePrefix) {
		this.classNamePrefix = classNamePrefix;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public void setAuthorName(String authorName) {
		this.authorName = authorName;
	}
}
