package com.cftech.productclassify.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.productclassify.model.Productclassify;
import com.cftech.productclassify.dao.ProductclassifyMapper;
import com.cftech.productclassify.service.ProductclassifyService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 产品分类ServiceImpl
 *
 * @author Buyj
 * @date: 2020-09-22 18:06
 */
@Service("productclassifyService")
public class ProductclassifyServiceImpl extends GenericServiceImpl<Productclassify> implements ProductclassifyService {

    @Autowired
    @Qualifier("productclassifyMapper")
    private ProductclassifyMapper productclassifyMapper;

    @Override
    public GenericDao<Productclassify> getGenericMapper() {
        return productclassifyMapper;
    }

    @Override
    public List<Productclassify> fetchTreeByPage(Conds conds, Sort sort, int pageNo, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("offset", pageNo > 0 ? pageNo : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return productclassifyMapper.fetchTreeByPage(params);
    }

}