package com.cftech.workshop.speech.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author byj
 * @date: 2018-06-29 14:18
 */
@Data
public class Speech implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 演讲者名称 */
    @ExportConfig(value = "演讲者名称", width = 100)
    private String speech_name;
    /* 演讲者名称 */
    @ExportConfig(value = "演讲者名称", width = 100)
    private String speech_name_en;
    /* 演讲者图片 */
    @ExportConfig(value = "演讲者图片", width = 100)
    private String speech_picture;

    @ExportConfig(value = "演讲者大图",width = 100)
    private String speech_picture_big;
    /* 描述 */
    @ExportConfig(value = "描述", width = 100)
    private String speech_describe;
    /* 描述 */
    @ExportConfig(value = "描述", width = 100)
    private String speech_describe_en;
    /* 研讨会ID */
    @ExportConfig(value = "研讨会ID", width = 100)
    private Long workshop_id;
    /* 内容 */
    @ExportConfig(value = "内容", width = 100)
    private String content_speech;
    /* 内容 */
    @ExportConfig(value = "内容", width = 100)
    private String content_speech_en;
    private String speech_position;
    private String speech_position_en;
    private String speech_title;
    private String speech_title_en;
    private Long sort;
    /* 演讲嘉宾店里量 */
    private Long clicks;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Speech() {
        this.delFlag = false;
        this.status = "0";
    }

}