package com.cftech.addresst.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aspose.words.IFieldMergingCallback;
import com.cftech.addresst.model.Address;
import com.cftech.addresst.dao.AddressMapper;
import com.cftech.addresst.model.AddressVO;
import com.cftech.addresst.model.Area;
import com.cftech.addresst.service.AddressService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.sys.security.UserUtils;
import com.esotericsoftware.minlog.Log;
import org.apache.poi.hssf.record.chart.AxisUsedRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

/**
* 收货地址管理ServiceImpl
*
* @author Licc
* @date: 2020-09-29 17:17
*/
@Service("addressService")
public class AddressServiceImpl extends GenericServiceImpl<Address> implements AddressService {

@Autowired
@Qualifier("addressMapper")
private AddressMapper addressMapper;

@Override
public GenericDao<Address> getGenericMapper() {
return addressMapper;
}

    @Override
    public List<Area> listArea() {
        return addressMapper.listArea();
    }

    @Override
    public JSONObject addressList(String openId) {
        JSONObject rtnJson = new JSONObject();
    try {

        if (openId.equals("")){
            rtnJson.put("errorNo","1");
            rtnJson.put("errorMsg","openId不能为空");
            return rtnJson;
        }
        List<AddressVO> addressList = addressMapper.addressList(openId);
        Log.info("参数:"+addressList);
        if (!addressList.equals("")||addressList!=null){
            rtnJson.put("errorNo","0");
            rtnJson.put("data",addressList);
        }
    }catch (Exception e){
        e.printStackTrace();
        rtnJson.put("errorNo","1");
    }

        return rtnJson;
    }

    @Override
    public JSONObject addressId(Long id) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (id.equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","id不能为空");
            }
            List<AddressVO> addressVOS = addressMapper.addressId(id);
            if (addressVOS!=null){
                Log.info("参数:"+addressVOS);
                rtnJson.put("errorNo","0");
                rtnJson.put("errorMsg",addressVOS);
            }
        }catch (Exception e){
           e.printStackTrace();
            rtnJson.put("errorNO","1");
        }
        return rtnJson;
    }


    @Transactional
    @Override
    public JSONObject addressAdd(Address address) {
        JSONObject rtnJson = new JSONObject();

        try {
            if (address.getOpenId().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","openid不能为空");
            }
            if (address.getAddressName().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","收货人姓名不能为空");
            }
            if (address.getPhone().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","手机号码不能为空");
            }
            if (address.getAddress().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","详细地址不能为空");
            }
            address.setOpenId(address.getOpenId());
            address.setAccountsId(address.getAccountsId());
            address.setDelFlag(false);
            address.setAddressName(address.getAddressName());
            address.setPhone(address.getPhone());
            address.setAddress(address.getAddress());
            address.setProvinceId(address.getProvinceId());
            address.setCityId(address.getCityId());
            address.setAreaId(address.getAreaId());

            if ("1".equals(address.getWhether().toString())){
            address.setWhether(address.getWhether());
                Long whether = address.getWhether();
                String openId = address.getOpenId();
                Integer list = addressMapper.whetherList(openId);
                if ( list!=null) {
                    HashMap<String, Object> param = new HashMap<>();
                    param.put("whether", whether);
                    param.put("openId", openId);
                    int i = addressMapper.updateWhether(param);
                    if (i == 0) {
                        rtnJson.put("errorNo", "1");
                        rtnJson.put("errorMsg", "新增失败");
                    }
                }
                addressMapper.save(address);
                rtnJson.put("errorNo","0");
                rtnJson.put("errorMsg","新增成功");

            }
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo","1");
        }
        return rtnJson;
    }
    @Transactional
    @Override
    public JSONObject updateAddress(Address address) {
        JSONObject rtnJson = new JSONObject();
        try {
            if (address.getOpenId().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","openid不能为空");
            }
            if (address.getAddressName().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","收货人姓名不能为空");
            }
            if (address.getPhone().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","手机号码不能为空");
            }
            if (address.getAddress().equals("")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","详细地址不能为空");
            }
            Log.info("参数:"+address);
            address.setId(address.getId());
            address.setAddressName(address.getAddressName());
            address.setPhone(address.getPhone());
            address.setAddress(address.getAddress());
            address.setProvinceId(address.getProvinceId());
            address.setCityId(address.getCityId());
            address.setAreaId(address.getAreaId());
            if ("1".equals(address.getWhether().toString())){
                address.setWhether(address.getWhether());
                Long whether = address.getWhether();
                String openId = address.getOpenId();
                Integer list = addressMapper.whetherList(openId);
                if ( list!=null) {
                    HashMap<String, Object> param = new HashMap<>();
                    param.put("whether", whether);
                    param.put("openId", openId);
                    int i = addressMapper.updateWhether(param);
                    if (i == 0) {
                        rtnJson.put("errorNo","1");
                        rtnJson.put("errorMsg", "修改失败");
                    }
                }
            }
            int i = addressMapper.update(address);
            if (i>0) {
                rtnJson.put("errorNo","0");
                rtnJson.put("errorMsg","修改成功");
            }else {
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","修改失败");
            }

        }catch (Exception e){
            e.printStackTrace();

        }
        return rtnJson;
    }

    @Override
    public JSONObject deleteAddress(String id) {
         JSONObject rtnJson = new JSONObject();
         try {
             if (id.equals("")){
                 rtnJson.put("errorNo","1");
                 rtnJson.put("errorMsg","id不能为空");
             }
             int delete = addressMapper.delete(id);
             if (delete>0){
                 rtnJson.put("errorNo","0");
                 rtnJson.put("errorMsg","删除成功");
             }
         }catch (Exception e){
             e.printStackTrace();
             rtnJson.put("errorNo","0");
         }
        return rtnJson;
    }

}