package com.cftech.order.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单管理
 *
 * @author Licc
 * @date: 2020-10-10 15:37
 */
@Data
public class OrderDetail implements Serializable {

    /* 主键id */
    private Long id;
    /* 订单id */
    @ExportConfig(value = "订单id", width = 100, showLevel = 1)
    private Long orderId;
    /* 商品id */
    @ExportConfig(value = "商品id", width = 100, showLevel = 1)
    private Long drugsId;

    /* 商品数量 */
    @ExportConfig(value = "商品数量", width = 100, showLevel = 1)
    private Long drugsNum;
    /* 用户所属公众号id */
    @ExportConfig(value = "用户所属公众号id", width = 100, showLevel = 1)
    private String openid;
    /* 商品价格 */
    @ExportConfig(value = "商品价格", width = 100, showLevel = 1)
    private Double price;
    /* 商品总价 */
    @ExportConfig(value = "商品实际价格", width = 100, showLevel = 1)
    private Double amount;
    /* 商品编码 */
    @ExportConfig(value = "商品编码", width = 100, showLevel = 1)
    private String drugsCode;
    /* 商品sku(规格) */
    @ExportConfig(value = "商品sku(规格)", width = 100, showLevel = 1)
    private String drugsSku;
    /* 对应erp物料号 */
    @ExportConfig(value = "对应erp物料号", width = 100, showLevel = 1)
    private String drugsMateriel;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public OrderDetail() {
        this.delFlag = false;
        this.status = "0";
    }

}