var signIn = (function () {
  'use strict';
  var SignIn = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/meeting/getqrcode',
      postApi: G.baseUri() + '/mobile/auth/meeting/getqiandao',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/sign-in.json';
      p.params.postApi = 'json/code.json';

    }
 p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '8',
          cfApp: cfApp
        });
        sideDiv.init();
        log();
        loadData();
        //postData();
$('.language').click(function () {
  if(!p.english){
location.href = 'qrcode-sign-in-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
  }else{
location.href = 'qrcode-sign-in.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
  }
          
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {

      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "二维码签到",
        keyword: "二维码签到",
        keywordid: cfApp.getQueryString('id'),
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {

      });
    }

    var loadData = function () {
      if(p.english){
        $.showLoading("Loading");
      }else{
        $.showLoading();
      }

      var formdata = {
        meetingId: cfApp.getQueryString('id'),
        member_uid:p.empInfo.memberId
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {
          var content = $('#template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('.content').append(htmlStr);
          var text=retdata.qrCode;
          var divId="qrcode";
          var qrcode=new QRCode(divId,{
            render: "canvas", //也可以替换为table
            text:text
          });
        }
      });
    }

    var postData = function () {



      wx.scanQRCode({
        needResult: 0, // 默认为0，扫描结果由微信处理，1则直接返回扫描结果，
        scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是一维码，默认二者都有
        success: function (res) {
          var result = res.resultStr; // 当needResult 为 1 时，扫码返回的结果

          var formdata = {
            member_uid: p.empInfo.memberId
          };
          G.ajax(G.devModePost, p.params.dataApi, formdata, function (retdata) {

            if (retdata.errorNo == '0') {

            }
          });
        }
      });





    }

  };

  return SignIn;
})();