var feedback = (function () {
  'use strict';
  var Feedback = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/active/getactiv',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/interaction.json';

    }
    p.page = 0;
    p.loading = false;
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);
    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side({
          currentIndex: '6',
          cfApp: cfApp

        });
        sideDiv.init();
        log();
        loadData();
        initInfinite();
        event();
        $('.language').click(function () {
          if(!p.english){
location.href = 'feedback-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
          }else{
location.href = 'feedback.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
          }
          
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "研讨会",
        modulename: "意见反馈",
        keyword: "意见反馈",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/adiea/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      if(p.english){
        $.showLoading("Loading");
      }else{
        $.showLoading();
      }

      var formdata = {
        meetingId:cfApp.getQueryString('id'),
        openid: p.empInfo.openId,
        page: p.page,
        pagesize: 10,
        type: 1
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {

          var content = $('#list-template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('#list').append(htmlStr);
          if (retdata.data.length < 10) {
            $('.weui-loadmore').remove();
            p.loading = true;
          } else {
            p.page++;
            p.loading = false;
          }

        }

      });


    }



    var initInfinite = function () {
      $('body').infinite().on("infinite", function () {
        if (p.loading) return;
        p.loading = true;

        setTimeout(function () {

          loadData();

        }, 800);
      });
    };

    var event = function () {
      $('#list').on('click', 'li', function () {
        var id = $(this).attr('id');
        // var type=$(this).attr('data-type');
        if (p.english) {
          location.href = 'survey-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+'&english=1'+'&paperId='+id;
        } else {
          location.href = 'survey.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+'&paperId='+id;
        }



      })
    }


  };

  return Feedback;
})();