package com.cftech.authentication.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 身份验证
 *
 * @author Buyj
 * @date: 2020-11-23 16:56
 */
@Data
public class Authentication implements Serializable {

    /* 主键id */
    private Long id;
    @ExportConfig(value = "姓名", width = 100)
    private String name;
    /* 省份证号码 */
    @ExportConfig(value = "省份证号码", width = 100)
    private String idCard;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;

    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    @ExportConfig(value = "描述")
    private String description;

    /* 创建时间 */
    @ExportConfig(value = "创建时间",width = 150,showLevel = 1)
    private Date createTime;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Authentication() {
        this.delFlag = false;
        this.status = "0";
    }

}