package com.cftech.activity.oil.aop;

import com.cftech.activity.log.model.OilLog;
import com.cftech.activity.log.service.OilLogService;
import com.cftech.activity.oil.model.Config;
import com.cftech.activity.oil.model.Oil;
import com.cftech.activity.oil.service.ConfigService;
import com.cftech.activity.oil.service.OilService;
import com.cftech.core.sql.Conds;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by faye on 2017/8/23.
 */
@Aspect
@Service
public class OilAopService {

    private static final Logger log=LoggerFactory.getLogger(OilAopService.class);

    @Autowired
    private OilLogService oilLogService;

    @Autowired
    private OilService oilService;

    @Autowired
    private ConfigService configService;

    /**
     * Pointcut
     * 定义Pointcut，Pointcut的名称为aspectjMethod()，此方法没有返回值和参数
     * 该方法就是一个标识，不进行调用
     */
    @Pointcut("execution(* com.cftech..*.*AddOil(..))")
//    @Pointcut("execution(* *..*.fetchById*(..))")
//    @Pointcut("execution(* com..*.*ServiceImpl.oil*(..))")
    public void aspectjMethod(){}

    /**
     * Before
     * 在核心业务执行前执行，不能阻止核心业务的调用。
     * @param joinPoint
     */
    @Before("aspectjMethod()")
    public void beforeAdvice(JoinPoint joinPoint) {
        System.out.println("-----beforeAdvice().invoke-----");
    }

    /**
     * After
     * 核心业务逻辑退出后（包括正常执行结束和异常退出），执行此Advice
     * @param joinPoint
     */
    @After(value = "aspectjMethod()")
    public void afterAdvice(JoinPoint joinPoint) {
        System.out.println("-----afterAdvice().invoke-----");
    }

    /**
     * Around
     * 手动控制调用核心业务逻辑，以及调用前和调用后的处理,
     *
     * 注意：当核心业务抛异常后，立即退出，转向AfterAdvice
     * 执行完AfterAdvice，再转到ThrowingAdvice
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around(value = "aspectjMethod()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        System.out.println("-----aroundAdvice().invoke-----");
        System.out.println(" 此处可以做类似于Before Advice的事情");
        //调用核心逻辑
        Object retVal = pjp.proceed();
        System.out.println(" 此处可以做类似于After Advice的事情");
        System.out.println("-----End of aroundAdvice()------");
        return retVal;
    }

    /**
     * AfterReturning
     * 核心业务逻辑调用正常退出后，不管是否有返回值，正常退出后，均执行此Advice
     * @param joinPoint
     */
    @AfterReturning(value = "aspectjMethod()", returning = "retVal")
    public void afterReturningAdvice(JoinPoint joinPoint,Object retVal) {
        System.out.println("-----afterReturningAdvice().invoke-----");
        //System.out.println("Return Value: " + retVal.getClass().getName());
        Object[] args=joinPoint.getArgs();
        if(args!=null&&args.length>0){
            String openId=args[1].toString();
            Long accountsId=Long.parseLong(args[0].toString());
            String type=args[2].toString();
            Conds oilConds=new Conds();
            oilConds.equal("accounts_id",accountsId);
            oilConds.equal("del_flag","0");
            Oil oil=oilService.fetchSearchByConds(oilConds);
            if(oil==null){
                log.info("未获取到可用的活动!");
                return ;
            }
            Conds configConds=new Conds();
            configConds.equal("accounts_id",accountsId);
            configConds.equal("type",type);
            configConds.equal("del_flag","0");
            Config config=configService.fetchSearchByConds(configConds);
            if(config==null){
                log.info("未获取到机会获取类型:"+type);
                return;
            }
//            conds.equal("activity_id",oil.getId());
            Conds conds=new Conds();
            conds.equal("open_id",openId);
            conds.equal("accounts_id",accountsId);
            conds.equal("type",type);
            conds.equal("del_flag","0");
            OilLog log=oilLogService.fetchSearchByConds(conds);
            if(log!=null){
                return;
            }
            log=new OilLog();
            log.setOpenId(openId);
            log.setTitle(oil.getTitle());
            log.setActivityId(oil.getId());
            log.setAccountsId(accountsId);
            log.setType(type);
            log.setFrom("Oil");
            oilLogService.save(log);
        }else{
            log.info("未获取到参数"+joinPoint+"; retVal:"+retVal);
        }
    }

    /**
     * 核心业务逻辑调用异常退出后，执行此Advice，处理错误信息
     *
     * 注意：执行顺序在Around Advice之后
     * @param joinPoint
     * @param ex
     */
    @AfterThrowing(value = "aspectjMethod()", throwing = "ex")
    public void afterThrowingAdvice(JoinPoint joinPoint, Exception ex) {
        System.out.println("-----afterThrowingAdvice().invoke-----");
        System.out.println(" 错误信息："+ex.getMessage());
        ex.printStackTrace();
        /*System.out.println(" 此处意在执行核心业务逻辑出错时，捕获异常，并可做一些日志记录操作等等");
        System.out.println(" 可通过joinPoint来获取所需要的内容");
        System.out.println("-----End of afterThrowingAdvice()------");*/
    }

}
