package com.cftech.workshop.workshop.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author byj
 * @date: 2018-06-22 17:30
 */
@Data
public class Workshop implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100 ,showLevel = 1)
    private String number;
    @ExportConfig(value = "序号", width = 100 ,showLevel = 2)
    private Long sort;
    @ExportConfig(value = "预导入姓" , width = 100,showLevel = 2)
    private String surname;
    /* 预导入名 */
    @ExportConfig(value = "预导入姓名", width = 100,showLevel = 2)
    private String first_name;
    /* 性别 */
    @ExportConfig(value = "性别", width = 100,showLevel = 2)
    private String gender;
    /* 公司 */
    @ExportConfig(value = "公司(CN)", width = 100,showLevel = 2)
    private String organization;
    /* 职位 */
    @ExportConfig(value = "预导入职位", width = 100,showLevel = 2)
    private String position;
    /* 邮箱 */
    @ExportConfig(value = "邮箱", width = 100,showLevel = 2)
    private String email;
    /* 手机号码 */
    @ExportConfig(value = "手机号码", width = 100,showLevel = 2)
    private String phone;
    /* 研讨会ID */
    @ExportConfig(value = "研讨会ID", width = 100)
    private Long wsid;
    /* 邀请码 */
    @ExportConfig(value = "邀请码", width = 100,showLevel = 2)
    private String invitcode;
    /*客户分类*/
    @ExportConfig(value = "客户分类" , width = 100 , showLevel = 2)
    private  String peopletype;
    @ExportConfig(value = "公司(EN)", width = 100,showLevel = 2)
    private String organization_en;
    /* 会员ID */
    @ExportConfig(value = "会员ID", width = 100 ,showLevel = 1)
    private String member_uid;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    private String name_en;
    private String table_number;
    private String factory_number;
    private String drive_number;
    private String del_flag;
    private String accounts_id;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Workshop() {
        this.delFlag = false;
    }

}