package com.cftech.common.typeappform.service;

import com.cftech.common.cancelitems.model.Cancelitems;
import com.cftech.common.grantitems.model.Grantitems;
import com.cftech.common.typeappform.model.AppitemsGrantReport;
import com.cftech.common.typeappform.model.TypeAppForm;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 类型申请单Service
*
* @author faye
* @date: 2019-08-14 16:52
*/
public interface TypeAppFormService extends GenericService<TypeAppForm> {

    boolean save(TypeAppForm typeAppForm,String items);



    boolean updatecancelSubmit(TypeAppForm typeAppForml,List<Cancelitems> cancelitems);

    boolean updateSubmitGrantCount(TypeAppForm typeAppForm,List<Grantitems> grantitems);


    boolean updateMarketRefuse(TypeAppForm typeAppForm);

    List<AppitemsGrantReport> getAppitemsGrantReport(String typeform);

    String getSumGrantPrice(Conds conds,String  type);

    /**
     * 分页查询
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @param isDisRole 是否是供应商角色，仅查询供应商数据
     * @return
     */
    List<TypeAppForm> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize,String isDisRole);

     int countServer(Conds conds,String isDisRole);
}
