package com.cftech.mp.wechat.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * wx_mp_wechat_qrcode 实体类
 * Created by mb 01/11/2016.
 */ 
@Data
@NoArgsConstructor
public class QrcodeDto implements Serializable {
	/**
	 * id
	 */
	private Integer id;

	/**
	 * 创建时间
	 */
	private Timestamp createTime;

	/**
	 * 修改时间
	 */
	private Timestamp updateTime;

	/**
	 * 创建人
	 */
	private Long createBy;

	/**
	 * 最后一次修改人
	 */
	private Long updateBy;

	/**
	 * 链接码
	 */
	private String ticket;

	/**
	 * 回复类型 text，news,store 
	 */
	private String replyType;

	/**
	 * 回复内容
	 */
	private String contentSource;

	/**
	 * QR_SCENE QR_LIMIT_SCENE
	 */
	private String actionName;

	/**
	 * 有效时间
	 */
	private Integer expireSeconds;

	/**
	 * 短链接
	 */
	private String shortUrl;

	/**
	 * 公众号id
	 */
	private Long accountsid;

	/**
	 * 是否删除
	 */
	private String delFlag;

	/**
	 * 失效时间
	 */
	private Timestamp esEndtime;
	
	/**
	 *二维码参数
	 */
	private String sence;
	
	/**
	 * 门店名称
	 */
	private String storeName;
	

}