package com.cftech.member.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi.model.Exhibi;
import com.cftech.cms.exhibi.service.ExhibiService;
import com.cftech.collection.model.Collection;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Cond;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.*;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.member.model.Member;
import com.cftech.member.model.MemberOffline;
import com.cftech.member.service.*;
import com.cftech.module.activity.core.model.ActivityBaseResultDto;
import com.cftech.module.activity.core.model.ActivityBaseResultEntity;
import com.cftech.module.activity.core.service.ActivityBaseResultService;
import com.cftech.mp.fans.model.MpFanssEntity;
import com.cftech.mp.fans.service.MpFanssService;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.model.WorkshopDto;
import com.cftech.workshop.workshop.service.WorkshopService;
import lombok.extern.slf4j.Slf4j;
import org.mp.api.wxbase.wxmedia.JwMediaAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * Created by lisw on 2017/8/29.
 * 会员相关接口
 */
@Slf4j
@RestController
@RequestMapping("/mobile/auth/member")
public class MobileMemberController {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private PhoneCodeService phoneCodeService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private MpFanssService fanssService;

    @Autowired
    private MemberTagsService memberTagsService;

    @Autowired
    private MpAccountsService accountsService;

    @Autowired
    private MemberOfflineService memberOfflineService;

    @Autowired
    private MemberCarsService memberCarsService;

    @Autowired
    private WorkshopService workshopService;

    @Autowired
    private MpTokenUtil tokenUtil;

    @Autowired
    private CollectionService collectionService;

    @Autowired
    private ExhibiService exhibiService;

    @Autowired
    private MeetingService meetingService;

    @Autowired
    private ActivityBaseResultService activityBaseResultService;

    /**
     * 序列化Redis
     *
     * @return
     */
    public boolean init() {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer(stringSerializer);
        //redisTemplate.setValueSerializer(stringSerializer);
        redisTemplate.setHashKeySerializer(stringSerializer);
        redisTemplate.setHashValueSerializer(stringSerializer);
        return true;
    }

    /**
     * 判断用户是否注册会员
     * @param openid  微信OPENID
     * @return
     */
    @RequestMapping(value = "/judgeregis", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject judgeregis(String openid){
        JSONObject jsonObject = new JSONObject();
       try {
           if(StringUtils.isNoneBlank(openid)){
               Conds conds= new Conds();
               conds.equal("open_id",openid);
               conds.equal("del_flag",0);
               Sort sort = new Sort("create_time",OrderType.DESC);
               List<Member> list = memberService.fetchSearchByPage(conds,sort,0,0);
               if(list.size()==0){ //未注册
                   jsonObject.put("errorNo",3);
               }else{
                   jsonObject.put("errorNo",4);  //已经注册
               }
           }else{
               jsonObject.put("errorNo",2);
           }
       }catch (Exception e){
           e.printStackTrace();
           jsonObject.put("errorNo",1);
       }
        return  jsonObject;
    }

    /**
     * 邀请码
     * @param invitcode
     * @return
     */
    @RequestMapping(value = "/judgeivitecode", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject judgeivitecode(String invitcode,String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            Conds conds = new Conds();
            conds.equal("w.invitcode",invitcode);
            conds.equal("w.del_flag",0);
            Sort sort = new Sort("w.create_time", OrderType.DESC);
            List<WorkshopDto> list = workshopService.searchmembershop(conds,sort,0,0);
            if(list.size()==0){
                jsonObject.put("errorNo",2); //验证无效
            }else{
                    for(WorkshopDto workshop : list){
                        if(workshop.getStatus().equals("1")||workshop.getStatus().equals("2")){
                            jsonObject.put("errorNo",3); //邀请码已经被使用
                        }else if(workshop.getStatus().equals("0")||workshop.getStatus().equals("-1")){
                            jsonObject.put("meetingId",workshop.getWsid());
                            jsonObject.put("errorNo",0); //调到注册页面
                            jsonObject.put("organization",workshop.getOrganization());
                            jsonObject.put("surname",workshop.getSurname());
                            jsonObject.put("name",workshop.getFirst_name());
                            jsonObject.put("sex",workshop.getGender());
                        }
                    }
            }

        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * @param accountsId
     * @param member
     * @param code
     * @return 0:注册成功 1:系统异常 2:参数错误 3:验证码不正确 4:手机号被占用  5:此openId已注册
     */
    @RequestMapping(value = "/register", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject register(Long accountsId, String openId, Member member, String code,String invitcode) {
        init();
        JSONObject rtnJson = new JSONObject();
        if (StringUtils.isBlank(member.getName())
               /* || StringUtils.isBlank(member.getPhone())*/
                || StringUtils.isBlank(member.getOpenId())
                /*|| StringUtils.isBlank(code)*/
                ) {
            rtnJson.put("errorNo", 2);
            return rtnJson;
        }
        try {
            int existMember = existMember(member.getOpenId(), accountsId, member.getPhone());
            if (existMember == 0) {
                /*String redisKey = "phoneCode:" + accountsId + ":" + member.getPhone();//组装验证码的key
                Object phoneCode = redisTemplate.opsForValue().get(redisKey);//获取验证码
                if (phoneCode != null) {
                    String phoneCodeStr = phoneCode.toString();
                    if (!StringUtils.equals(phoneCodeStr, code)) { //验证码不正确
                        rtnJson.put("errorNo", 3);
                    } else {*/
                        member.setOilSum("0");
                        member.setNumber(codingruleUtils.getNumber(accountsId, Member.class.getName()));
                        member.setMember_uid(UUID.randomUUID().toString());
                        if(StringUtils.isNotBlank(member.getStoreid())){
                            Cosconfig cosconfig = new Cosconfig();
                            cosconfig.setCosType("qcloud");
                            /**
                             * 按照需要上传逻辑，做上传的相关配置
                             */
                            net.sf.json.JSONObject mediaJson= JwMediaAPI.downMedia(tokenUtil.getToken(accountsId),member.getStoreid(),"",cosconfig);
                            String image = mediaJson.getString("fileName");
                            member.setStoreid(image);
                        }
                        memberService.updateworkshop(member,invitcode);
                       // memberService.save(member);
                        //saveAddOil(accountsId,member.getOpenId(),"register");
                        //redisTemplate.delete(redisKey);//注册成功后删除验证码,防止重复使用
                        rtnJson.put("errorNo", 0);
                  /*  }
                } else {
                    rtnJson.put("errorNo", 3);
                }*/
            } else if (existMember == 1) {
                rtnJson.put("errorNo", 4);
            } else if (existMember == 2) {
                rtnJson.put("errorNo", 5);
            } else {
                rtnJson.put("errorNo", 6);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();

        }
        return rtnJson;
    }

    boolean saveAddOil(Long accountsId,String openId,String type){
        return true;
    }





    /**
     * 修改会员信息
     *
     * @param member
     * @return
     */
    @RequestMapping(value = "updateMember", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updateMember(Member member, Long accountsId, String code) {
        JSONObject rtnJson = new JSONObject();
        try {
            Member valid = memberService.fetchById(member.getId());
            if(StringUtils.isNotBlank(valid.getStatus()) && StringUtils.equals(valid.getStatus(),"1")){//修改过身份证号，不可再次修改
                rtnJson.put("errorNo", 3);
                return rtnJson;
            }
            String redisKey = "phoneCode:" + accountsId + ":" + member.getPhone();//组装验证码的key
            if (StringUtils.isNotBlank(member.getPhone())) {
                Object phoneCode = redisTemplate.opsForValue().get(redisKey);//获取验证码
                if (phoneCode != null) {
                    String phoneCodeStr = phoneCode.toString();
                    if (!StringUtils.equals(phoneCodeStr, code)) {//判断验证码是否正确
                        rtnJson.put("errorNo", 2);
                        return rtnJson;
                    }
                }else{
                    rtnJson.put("errorNo", 2);
                    return rtnJson;
                }
            }
            if (StringUtils.isBlank(valid.getStatus())) {
                //标识为身份证号，已经修改过一次，下次不可再次修改
                member.setStatus("1");
                //清除车辆信息，重新绑定会员卡
                memberCarsService.updateMemberId(member.getId());

                //将会员卡信息清除
                member.setMemberId("");

            }
            memberService.update(member);
            redisTemplate.delete(redisKey);//注册成功后删除验证码,防止重复使用
            rtnJson.put("errorNo", 0);
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();

        }
        return rtnJson;
    }


    /**
     * 完善信息
     *
     * @param member
     * @return
     */
    @RequestMapping(value = "perfectInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject perfectInfoAddOil(Long accountsId,String openId,@RequestParam(value="type",required=false,defaultValue="perfectinfo") String type,Member member) {
        JSONObject rtnJson = new JSONObject();
        Member memberExits = memberService.fetchById(member.getId());
        try {
            if (StringUtils.isNotBlank(member.getOther())) {//完善信息
                memberService.update(member);
                rtnJson.put("errorNo", 0);
            }
            if(StringUtils.isNotBlank(memberExits.getOther())){
                rtnJson.put("errorNo", 2);//非第一次完善信息
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();

        }
        return rtnJson;
    }

    /**
     * DMS接口
     * 修改会员信息
     *
     * @return
     */
    @RequestMapping(value = "synMember", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject synMember(String phone, String newPhone, String idCard, String name, String birthday, String area, String sex, String level, String mCard, String storeNo, HttpServletRequest request) {
        JSONObject rtnJson = new JSONObject();
        log.info("同步会员信息接口调取=====");
        Enumeration enumeration =request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String paramName = (String) enumeration.nextElement();
            String paramValue = request.getParameter(paramName);
            log.info("参数名:"+paramName+"\t"+"参数值:"+paramValue);
        }
        try {
            if (StringUtils.isBlank(phone) || StringUtils.isBlank(idCard) || StringUtils.isBlank(mCard)) {
                rtnJson.put("errorNo", 3);
                rtnJson.put("errorMsg", "phone or idCard or mCard is Empty");
                return rtnJson;
            }
            MemberOffline memberCardId = null;
            //Member member = memberService.fetchSearchByConds(conds);
            Conds cardNoConds = new Conds();
            cardNoConds.equal("member_id", mCard);
            memberCardId = memberOfflineService.fetchSearchByConds(cardNoConds);
            //member = memberService.fetchSearchByConds(cardNoConds);
            if (memberCardId == null) {//如果通过身份证号或者会员卡号都未查到数据，则进行新增线下会员操作
                memberCardId = new MemberOffline();
                memberCardId.setPhone(phone);
                memberCardId.setCardid(idCard);
                memberCardId.setName(name);
                memberCardId.setBirthday(birthday);
                memberCardId.setSex(sex);
                memberCardId.setStoreid(storeNo);
                memberCardId.setMemberId(mCard);
                memberCardId.setLevel(level);
                memberCardId.setArea(area);
                memberOfflineService.save(memberCardId);
            } else {//如果通过身份证号或者会员卡号查到数据，则更新线下会员操作
                memberCardId.setCardid(idCard);
                memberCardId.setPhone(phone);
                memberCardId.setPhone(newPhone);
                memberCardId.setName(name);
                memberCardId.setBirthday(birthday);
                memberCardId.setSex(sex);
                memberCardId.setStoreid(storeNo);
                memberCardId.setMemberId(mCard);
                memberCardId.setLevel(level);
                memberCardId.setArea(area);
                memberOfflineService.update(memberCardId);
            }
//            if (member != null) {//如果通过身份证号或者会员卡号查到数据，则更新线上会员操作
//                member.setCardid(idCard);
//                member.setPhone(phone);
//                member.setPhone(newPhone);
//                member.setName(name);
//                member.setBirthday(birthday);
//                member.setSex(sex);
//                member.setStoreid(storeNo);
//                member.setMemberId(mCard);
//                member.setLevel(level);
//                member.setArea(area);
//                memberService.update(member);
//            }
            rtnJson.put("errorNo", 0);
            rtnJson.put("errorMsg", "syn Success");
        } catch (Exception e) {
            rtnJson.put("errorMsg", "网络错误");
            rtnJson.put("errorNo", 1);
            e.printStackTrace();

        }
        return rtnJson;
    }

    /**
     * 获取会员信息
     *
     * @param memberId
     * @return
     */
    @RequestMapping(value = "searchMember", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject searchMember(Long memberId,String memberName) {
        JSONObject rtnJson = new JSONObject();
        try {
            Member member = memberService.fetchById(memberId);
            rtnJson.put("errorNo", 0);
            rtnJson.put("data", member);
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();
        }
        return rtnJson;
    }


    /**
     * 获取积分流水记录
     */
    @RequestMapping(value = "integralRecord", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject integralRecord(Long memberId, int page, int pageSize) {
        JSONObject rtnJson = new JSONObject();
        Member member = memberService.fetchById(memberId);
        try {
            String res = RestFulUtils.getSearchMemberIntegralUrl(member.getMemberId(), page, pageSize);
            if(StringUtils.isNotBlank(res)){
                rtnJson = JSONObject.parseObject(res);
            }else{
                rtnJson.put("errorNo", 1);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
            e.printStackTrace();
        }
        return rtnJson;
    }


    /**
     * 获取验证码接口
     *
     * @param phone
     * @param accountsId
     * @return
     */
    @RequestMapping(value = "/searchCode", method = {RequestMethod.GET,RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject searchCode(String phone, Long accountsId) {
        init();
        JSONObject rtnJson = new JSONObject();
        try {
            String phoneCodeLength = SystemConfig.p.getProperty("sender.codeLength");
            String code = NumberUtil.getRandNum(Integer.valueOf(phoneCodeLength));// 根据数据库设置的验证码长度，生成随机码
            String redisKey = "phoneCode:" + accountsId + ":" + phone;
            redisTemplate.opsForValue().set(redisKey, code, 60*5, TimeUnit.SECONDS);
            String result = phoneCodeService.setPhoneCode(phone, "您的验证码为"+code+"，请在5分钟内输入。");
            log.info("本次获取验证码的手机号是:" + phone + ",生成的验证码是:" + code + ",返回结果是:" + result);
            rtnJson.put("errorNo", 0);
        } catch (Exception e) {
            log.info("获取验证码异常");
            rtnJson.put("errorNo", 1);
            e.printStackTrace();
        }
        return rtnJson;
    }

    /**
     * 检测会员是否注册或手机号是否被占用
     *
     * @param openId
     * @param accountsId
     * @param phone
     * @return 1:手机号被占用  2:此OPENID已经注册过会员
     */
    public int existMember(String openId, Long accountsId, String phone) {
        if(StringUtils.isNoneBlank()){
            Conds conds = new Conds();
            conds.equal("phone", phone);
            conds.equal("del_flag", 0);
            conds.equal("accounts_id", accountsId);
            Member existMember = memberService.fetchSearchByConds(conds);
            if (existMember != null) {
                return 1;
            }
        }
        Conds openIdConds = new Conds();
        openIdConds.equal("open_id", openId);
        openIdConds.equal("del_flag", 0);
        openIdConds.equal("accounts_id", accountsId);
        Member existOpenIdMember = memberService.fetchSearchByConds(openIdConds);
        if (existOpenIdMember != null) {
            return 2;
        }
        return 0;
    }

    @RequestMapping(value = "validPassword", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject rtnJson(String memberId, String password, String storeNo) {
        JSONObject rtnJson = new JSONObject();
        try {
            Member member = memberService.fetchById(memberId);
            System.out.println("原文: " + password);
            String key = SystemConfig.p.getProperty("MEMBER_PASSWORD_KEY");
            String encryptData = DESUtil.encrypt(password, key);
            if (RestFulUtils.validPassword(member.getMemberId(), encryptData, member.getMemberStoreId())) {
                rtnJson.put("errorNo", "0");
            } else {
                rtnJson.put("errorNo", "1");
            }
            //rtnJson.put("errorNo", "0");
        } catch (Exception e) {
            rtnJson.put("errorNo", "1");
            e.printStackTrace();
        }
        return rtnJson;
    }

    @RequestMapping(value = "storedRecord",method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject storedRecord(Long memberId,int page,int pageSize){
        JSONObject rtnJson = new JSONObject();
        try{
            Member member = memberService.fetchById(memberId);
            String res = RestFulUtils.findMoneyRecord(member.getMemberId(),page,pageSize);
            rtnJson = JSONObject.parseObject(res);
        }catch (Exception e){
            rtnJson.put("errorNo",1);
        }
        return rtnJson;
    }

    /**
     * 个人中心
     * @param openid 粉丝openid
     * @return
     */
    @RequestMapping(value = "/getmembercenter",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getmembercenter(String openid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(openid)){
                Conds conds = new Conds();
                conds.equal("open_id",openid);
                Sort sort = new Sort("create_time",OrderType.DESC);
                List<Member> list = memberService.fetchSearchByPageServer(conds,sort,0,0);
                if(list.size()>0){
                    jsonObject.put("errorNo",0);
                    for(Member member : list){
                        jsonObject.put("surname",member.getSurname());
                        jsonObject.put("name",member.getName());
                        jsonObject.put("imgrul",member.getImageurl());
                    }
                }

            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 编辑资料
     * @param member_uid
     * @return
     */
    @RequestMapping(value = "/getemembercenterdetails",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updatemembercenter(String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(member_uid)){
                Conds conds = new Conds();
                conds.equal("member_uid",member_uid);
                Member member = memberService.fetchSearchByConds(conds);
                jsonObject.put("errorNo",0);
                jsonObject.put("data",member);
                    jsonObject.put("data",member);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 修改个人资料
     * @param member
     * @return
     */
    @RequestMapping(value = "/updatemembercenter",method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updatemembercenter(Member member){
        Conds conds =new Conds();
        conds.equal("member_uid",member.getMember_uid());
        Member memberEx = memberService.fetchSearchByConds(conds);
        member.setId(memberEx.getId());
        JSONObject jsonObject = new JSONObject();
       try {
           if(member!=null){
                Boolean bool = memberService.update(member);
               if(bool){
                   jsonObject.put("errorNo",0);
               }
           }
       }catch (Exception e){
           e.printStackTrace();
           jsonObject.put("errorNo",1);
       }
        return  jsonObject;
    }

    /**
     * 我的收藏
     * @param openid 微信openid
     * @param page
     * @param pagesize
     * @return
     */
    @RequestMapping(value = "/getmycollection",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getmycollection(String openid,int page ,int pagesize){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(openid)){
                Conds conds = new Conds();
                conds.equal("user_id",openid);
                conds.equal("del_flag",0);
                Sort sort = new Sort("create_time",OrderType.DESC);
                List<Collection> list = collectionService.fetchSearchByPage(conds,sort,page,pagesize);
                if(list.size()>0&&list!=null){
                    jsonObject.put("errorNo",0);
                    JSONArray jsonArray = new JSONArray();
                    for(Collection collection : list){
                        Exhibi exhibi = exhibiService.fetchById(collection.getEntityId());
                        jsonArray.add(exhibi);
                        jsonObject.put("data",jsonArray);
                    }
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 我的活动
     * @param member_uid 会员UID
     * @param  type 0:已报名 1：已结束
     * @return
     */
    @RequestMapping(value = "/getmymeeting",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public  JSONObject getmymeeting(String member_uid,String type){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(member_uid)&&StringUtils.isNoneBlank(type)){
                Conds conds = new Conds();
                conds.equal("m.member_uid",member_uid);
                conds.equal("m.del_flag",0);
                Sort sort = new Sort("w.create_time",OrderType.DESC);
                List<WorkshopDto> list = workshopService.searchmembershop(conds,sort,0,0);
                if(list!=null&&list.size()>0){
                    JSONArray jsonArray = new JSONArray();
                    for(WorkshopDto workshopDto : list){
                        if(workshopDto.getStatus().equals("1")){ //报名
                            if(type.equals("0")){  //已报名
                                Meeting meeting = meetingService.fetchById(workshopDto.getWsid());
                                Date now = new Date(); //获得当前时间
                                Date endwstime = meeting.getEndTime();  //研讨会结束时间
                                if(now.getTime()-endwstime.getTime()<0){ //判断已报名的研讨会结束没有 <0:未结束 >0:结束
                                    jsonArray.add(meeting);
                                }
                            }else{ //已结束
                                Meeting meeting = meetingService.fetchById(workshopDto.getWsid());
                                Date now = new Date(); //获得当前时间
                                Date endwstime = meeting.getEndTime();  //研讨会结束时间
                                if(now.getTime()-endwstime.getTime()>0){
                                    jsonArray.add(meeting);
                                }
                            }
                            jsonObject.put("errorNo",0);
                        }
                    }
                    jsonObject.put("data",jsonArray);
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;

    }

    /**
     * 中奖纪录
     * @param openid
     * @return
     */
    @RequestMapping(value = "/getmywing",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getmywing(String openid,int page , int pagesize){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(openid)){
                jsonObject.put("errorNo",0);
                Conds conds = new Conds();
                conds.equal("result.open_id",openid);
                conds.equal("result.del_flag",0);
                Sort sort = new Sort("result.create_time",OrderType.DESC);
                List<ActivityBaseResultEntity> list = activityBaseResultService.selectmywin(conds,sort,page,pagesize);
                JSONArray jsonArray = new JSONArray();
                JSONObject jsonObject1 = new JSONObject();
                if(list!=null&&list.size()>0){

                    for(ActivityBaseResultEntity activityBaseResultEntity : list){
                        Meeting meeting = meetingService.fetchById(activityBaseResultEntity.getDescription());
                        if(meeting!=null){
                            jsonObject1.put("meeting_name",meeting.getTitle());
                            jsonObject1.put("meeting_nameEn",meeting.getTitleEn());
                        }
                        jsonObject1.put("prize",activityBaseResultEntity.getPrize()); //奖品名称
                        jsonObject1.put("wintime",activityBaseResultEntity.getCreateTime()); //中奖时间
                        jsonArray.add(jsonObject1);
                    }
                }
                jsonObject.put("data",jsonArray);
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",0);
        }
        return  jsonObject;
    }


}
