package com.cftech.like.web;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.like.model.Like;
import com.cftech.like.model.LikeDto;
import com.cftech.like.service.LikeService;
import com.cftech.sys.security.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.multipart.MultipartFile;
/**
 * 权限字符串说明:
 * 查看:public static final String LIKE_VIEW = "like:view"
 * 查看:public static final String Like_EDIT = "like:edit"
 * likeWeb
 * Created by mubo 10/05/2017.
 */
@Controller
@RequestMapping("/a/like")
public class LikeController {

    /**
     * likeService
     */
    public static final String LIKE_VIEW = "like:view";
    public static final String LIKE_EDIT = "like:edit";
    @Autowired
    private LikeService likeService;


    //返回列表页面
    @RequiresPermissions(value = LIKE_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(Model model, HttpServletRequest request,Long id,String moduleType) {
        model.addAttribute("id",id);
        model.addAttribute("moduleType",moduleType);
        return "like/likelist";
    }
    //获取列表数据
    @RequiresPermissions(value = LIKE_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, LikeDto likeDto, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("t.del_flag", false);
        conds.equal("t.accounts_id", accountsId);
        conds.equal("t.type",0);
        if(StringUtils.isNotBlank(likeDto.getEntitycontent())){
            conds.equal("t.entity_id",likeDto.getEntitycontent());
        }
        if(StringUtils.isNotBlank(likeDto.getModuleType())){
            conds.equal("t.module_type",likeDto.getModuleType());
        }

        String id = (String) request.getAttribute("id");
        if(StringUtils.isNotBlank(likeDto.getUserName()))
            conds.like("f.nickname",likeDto.getUserName());
        Sort sort = new Sort("t.create_time", OrderType.DESC);
        List<LikeDto> list = likeService.findLikeByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer likeCounts = likeService.findLikeCount(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", likeCounts);
        rtnJson.put("iTotalDisplayRecords", likeCounts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //导出数据
    @RequiresPermissions(value = LIKE_EDIT)
    @RequestMapping(value = "/exportListData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public void cardFetechData(String userName ,HttpServletRequest request , HttpServletResponse response) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("t.del_flag", false);
        conds.equal("t.accounts_id", accountsId);
        if(StringUtils.isNotBlank(userName)){
            conds.like("f.nickname",userName);
        }
        Sort sort = new Sort("t.create_time", OrderType.DESC);
        List<LikeDto> list = likeService.findLikeByPage(conds, sort, 0, 0);
        try {
            ExcelKit.$Export(LikeDto.class, response).toExcel(formatDateToExport(list), "点赞记录");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 构造导出数据
     * */
    private List<LikeDto> formatDateToExport(List<LikeDto> data){
        for (LikeDto likeDto:data) {
            String moduleNameTemp="";
            if(likeDto.getModuleType()!= null){
                switch (likeDto.getModuleType()){
                    case "1":
                        moduleNameTemp="新闻";
                        break;
                    default:
                        moduleNameTemp = "";
                        break;
                }
                likeDto.setModuleName(moduleNameTemp);
            }
            if(likeDto.getCreateTime()!=null){
                likeDto.setCreateTimeExport(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(likeDto.getCreateTime()));
            }
        }
        return data;
    }
}